<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$product         = $viewData['product'];
$isList          = isset($viewData['isList']) ? $viewData['isList'] : false;
$listMode        = isset($viewData['listMode']) ? $viewData['listMode'] : 'grid';
$layoutPositions = isset($viewData['position']) ? $viewData['position'] : 'addtocart';
$itemId          = vRequest::getInt('Itemid', 0);

if (!is_array($layoutPositions)) {
    $layoutPositions = [$layoutPositions];
}
?>
<div class="addtocart-area">
    <form method="post" class="product js-recalculate" action="<?php echo Route::_('index.php?option=com_virtuemart'); ?>" autocomplete="off">
        <div class="vm-customfields-container">
            <?php foreach ($layoutPositions as $layoutPosition) : ?>
                <?php echo shopFunctionsF::renderVmSubLayout('customfields', ['product' => $product, 'position' => $layoutPosition, 'isList' => $isList, 'listMode' => $listMode]); ?>
            <?php endforeach; ?>
        </div>
        <?php if (!VmConfig::get('use_as_catalog', 0) && !($product->product_discontinued && !VmConfig::get('discontinuedPrdsBrowseable', 1))) : ?>
            <?php echo shopFunctionsF::renderVmSubLayout('addtocartbar', ['product' => $product, 'isList' => $isList, 'listMode' => $listMode]); ?>
        <?php endif; ?>
        <?php if (!VmConfig::get('addtocart_popup', true)) : ?>
            <input type="hidden" name="task" value="add"/>
        <?php else : ?>
            <noscript><input type="hidden" name="task" value="add"/></noscript>
        <?php endif; ?>
        <input type="hidden" name="option" value="com_virtuemart"/>
        <input type="hidden" name="view" value="cart"/>
        <input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id; ?>"/>
        <input type="hidden" name="pname" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>"/>
        <input type="hidden" name="pid" value="<?php echo $product->virtuemart_product_id; ?>"/>
        <input type="hidden" name="Itemid" value="<?php echo $itemId; ?>"/>
    </form>
</div>
