<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

HTMLHelper::_('behavior.formvalidator');
?>
<div class="product-notify-page">
    <div class="page-header">
        <h1><?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY') ?></h1>
    </div>
    <p class="mb-4"><?php echo vmText::sprintf('COM_VIRTUEMART_CART_NOTIFY_DESC', $this->product->product_name); ?></p>
    <form method="post" action="<?php echo Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id) ; ?>" name="notifyform" class="form-validate">
        <div class="input-group mb-4">
            <div class="input-group-text" id="email-addon">@</div>
            <input type="email" class="form-control" name="notify_email" id="notify_email" placeholder="<?php echo Text::_('JGLOBAL_EMAIL') ?>" value="<?php echo $this->user->email ?>" aria-label="<?php echo Text::_('JGLOBAL_EMAIL'); ?>" aria-describedby="email-addon" required="true" />
            <button type="submit" class="btn btn-primary validate"><?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY'); ?></button>
        </div>
        <input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>" />
        <input type="hidden" name="option" value="com_virtuemart" />
        <input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>" />
        <input type="hidden" name="virtuemart_user_id" value="<?php echo $this->user->id; ?>" />
        <input type="hidden" name="task" value="notifycustomer" />
        <input type="hidden" name="controller" value="productdetails" />
        <?php echo shopfunctionsF::renderCaptcha('ask_captcha'); ?>
        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
    <div class="separator-line mb-4" aria-hidden="true" tabindex="-1"></div>
</div>
