<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app       = Factory::getApplication();
$document  = $app->getDocument();
$wa        = $document->getWebAssetManager();
$tabs      = [];
$groupKeys = [];

if (!empty($this->product->product_desc)) {
    $tab              = new stdClass();
    $tab->id          = 'product-description';
    $tab->name        = vmText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE');
    $tab->content     = $this->product->product_desc;
    $tab->tip         = '';
    $tab->description = '';

    $tabs[] = $tab;
}

if (!isset($this->product->customfieldsSorted['normal'])) {
    $this->product->customfieldsSorted['normal'] = [];
}

if (!empty($this->product->customfieldsSorted['tab'])) {
    foreach ($this->product->customfieldsSorted['tab'] as $customField) {
        if ($customField->field_type === 'G') {
            $customField->customfieldsSorted = [];
            $customField->childrenLocation   = time() . '-' . mt_rand();
        }

        $this->product->customfieldsSorted['normal'][] = $customField;

        if ($customField->field_type === 'G') {
            $groupKeys[$customField->virtuemart_custom_id] = array_key_last($this->product->customfieldsSorted['normal']);
        }
    }
}

if (!empty($this->product->customfieldsSorted['normal'])) {
    foreach ($this->product->customfieldsSorted['normal'] as $key => $customField) {
        if ($customField->is_hidden) {
            unset($this->product->customfieldsSorted['normal'][$key]);
        } elseif (array_key_exists($customField->custom_parent_id, $groupKeys)) {
            $groupKey = $groupKeys[$customField->custom_parent_id];

            if (isset($this->product->customfieldsSorted['normal'][$groupKey])) {
                $group = $this->product->customfieldsSorted['normal'][$groupKey];

                $group->customfieldsSorted[$group->childrenLocation][] = $customField;

                $this->product->customfieldsSorted['normal'][$groupKey] = $group;

                unset($this->product->customfieldsSorted['normal'][$key]);
            }
        }
    }

    foreach ($this->product->customfieldsSorted['normal'] as $customField) {
        if ($customField->field_type === 'G' && !empty($customField->customfieldsSorted[$customField->childrenLocation])) {
            $customField->display = shopFunctionsF::renderVmSubLayout('customfields', ['product' => $customField, 'position' => $customField->childrenLocation]);
        }

        if (empty($customField->display)) {
            continue;
        }

        $tab              = new stdClass();
        $tab->id          = 'product-customfield-' . $customField->field_type . '-' . $customField->virtuemart_customfield_id;
        $tab->name        = vmText::_($customField->custom_title);
        $tab->content     = $customField->display;
        $tab->tip         = $customField->custom_tip;
        $tab->description = $customField->custom_desc;

        $tabs[] = $tab;
    }
}

if ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview) {
    $tab              = new stdClass();
    $tab->id          = 'product-reviews';
    $tab->name        = vmText::_('COM_VIRTUEMART_REVIEWS');
    $tab->content     = $this->loadTemplate('reviews');
    $tab->tip         = '';
    $tab->description = '';

    $tabs[] = $tab;
}
?>
<?php if (!empty($tabs)) : ?>
    <ul class="nav nav-tabs-simple" id="product-details-tab" role="tablist">
        <?php foreach ($tabs as $key => $tab) : ?>
            <li class="nav-item" role="presentation">
                <button type="button" data-bs-target="#<?php echo $tab->id; ?>" id="<?php echo $tab->id; ?>-tab" class="nav-link<?php echo $key === 0 ? ' active' : ''; ?>" data-bs-toggle="tab" role="tab" aria-controls="<?php echo $tab->id; ?>" aria-selected="<?php echo $key === 0 ? 'true' : 'false'; ?>"><?php echo $tab->name; ?></button>
            </li>
        <?php endforeach; ?>
    </ul>
    <div class="tab-content mb-4">
        <?php foreach ($tabs as $key => $tab) : ?>
            <div class="tab-pane fade<?php echo $key === 0 ? ' show active' : ''; ?>" id="<?php echo $tab->id; ?>" role="tabpanel" aria-labelledby="<?php echo $tab->id; ?>-tab">
                <?php if (!empty($tab->tip)) : ?>
                    <div class="alert alert-info mb-4" role="alert">
                        <div class="d-flex">
                            <div class="tab-tip-icon me-2">
                                <i class="fas fa-info-circle fa-lg" aria-hidden="true"></i>
                            </div>
                            <div class="tab-tip">
                                <?php echo $tab->tip; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php echo $tab->content; ?>
                <?php if (!empty($tab->description)) : ?>
                    <div class="tab-field-description text-muted mt-4">
                        <?php echo $tab->description; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
