<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;

defined('_JEXEC') or die;

if (!$this->allowRating && !$this->allowReview && !$this->showRating && !$this->showReview) {
    return;
}

$reviewEditable   = true;
$maxRating        = VmConfig::get('vm_maximum_rating_scale', 5);
$ratingsShow      = VmConfig::get('vm_num_ratings_show', 3);
$reviewMinLength  = VmConfig::get('reviews_minimum_comment_length', 100);
$reviewMaxLength  = VmConfig::get('reviews_maximum_comment_length', 3800);
$reviewMinAlert   = addslashes(vmText::sprintf('COM_VIRTUEMART_REVIEW_ERR_COMMENT1_JS', VmConfig::get('reviews_minimum_comment_length', 100)));
$reviewMaxAlert   = addslashes(vmText::sprintf('COM_VIRTUEMART_REVIEW_ERR_COMMENT2_JS', VmConfig::get('reviews_maximum_comment_length', 3800)));
$reviewsDisplayed = 0;

if ($this->rating_reviews) {
    foreach ($this->rating_reviews as $review) {
        // Check if user already commented
        if ($review->created_by == $this->user->id && !$review->review_editable) {
            $reviewEditable = false;
        }
    }
}

$reviewScript = <<<EOT
function check_reviewform() {
    var form = document.getElementById('reviewform');

    if (form.comment.value.length < {$reviewMinLength}) {
        alert('{$reviewMinAlert}');
        return false;
    } else if (form.comment.value.length > {$reviewMaxLength}) {
        alert('{$reviewMaxAlert}');
        return false;
    }

    return true;
}

function refresh_counter() {
    var form = document.getElementById('reviewform');
    form.counter.value= form.comment.value.length;
}
EOT;
?>
<?php if ($this->allowRating || $this->allowReview) : ?>
    <div class="add-review-section mb-5">
        <?php if ($reviewEditable) : ?>
            <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id); ?>" name="reviewForm" id="reviewform" method="post">
                <h4 class="mb-3"><?php echo vmText::_('COM_VIRTUEMART_WRITE_REVIEW'); ?></h4>
                <?php if (empty($this->rating_reviews)) : ?>
                    <p><?php echo vmText::_('COM_VIRTUEMART_WRITE_FIRST_REVIEW'); ?></p>
                <?php endif; ?>

                <?php if ($this->allowRating) : ?>
                    <div class="mb-4">
                        <label for="vote" class="form-label d-block">
                            <?php echo vmText::_('COM_VIRTUEMART_RATING_FIRST_RATE'); ?>
                        </label>
                        <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => true, 'rating' => (!empty($this->review->vote) ? floatval($this->review->vote) : 0), 'readonly' => false, 'name' => 'vote', 'id' => 'vote', 'size' => 24]); ?>
                    </div>
                <?php endif; ?>

                <?php if ($this->allowReview) : ?>
                    <label for="comment" class="form-label">
                        <?php echo vmText::sprintf('COM_VIRTUEMART_REVIEW_COMMENT', VmConfig::get('reviews_minimum_comment_length', 100), VmConfig::get('reviews_maximum_comment_length', 2000)); ?>
                    </label>
                    <textarea class="form-control" id="comment" onblur="refresh_counter();" onfocus="refresh_counter();" onkeyup="refresh_counter();" name="comment" rows="5" cols="60"><?php echo !empty($this->review->comment) ? $this->review->comment : ''; ?></textarea>
                    <div class="d-flex flex-row form-group-text-counter align-items-center mt-2 mb-4">
                        <label for="counter" class="me-1">
                            <?php echo vmText::_('COM_VIRTUEMART_REVIEW_COUNT'); ?>
                        </label>
                        <input class="form-control form-control-sm text-center" type="text" value="0" id="counter" name="counter" disabled />
                    </div>
                    <?php vmJsApi::addJScript('check_reviewform', $reviewScript); ?>
                <?php endif; ?>

                <button type="submit" class="btn btn-primary" name="submit_review" onclick="return(check_reviewform());">
                    <?php echo vmText::_('COM_VIRTUEMART_REVIEW_SUBMIT'); ?>
                </button>

                <input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>"/>
                <input type="hidden" name="option" value="com_virtuemart"/>
                <input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id', 0); ?>"/>
                <input type="hidden" name="virtuemart_rating_review_id" value="0"/>
                <input type="hidden" name="task" value="review"/>
            </form>
        <?php else : ?>
            <div class="p-3 mb-2 bg-success text-white">
                <?php echo vmText::_('COM_VIRTUEMART_REVIEW_ALREADYDONE'); ?>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if ($this->showReview) : ?>
    <div class="customer-reviews-section">
        <?php if (!empty($this->rating_reviews)) : ?>
            <h4 class="mb-3"><?php echo vmText::_('COM_VIRTUEMART_REVIEWS'); ?></h4>
            <div class="customer-reviews">
                <?php foreach ($this->rating_reviews as $review) : ?>
                    <?php if (!empty($this->rating_reviews) && $review->published) : ?>
                        <?php $reviewsDisplayed++; ?>
                        <div class="customer-review mb-3">
                            <div class="d-flex flex-row align-items-center mb-1">
                                <div class="review-customer-icon me-2 text-muted" aria-hidden="true">
                                    <i class="fas fa-user-circle fa-2x"></i>
                                </div>
                                <div class="review-customer-name">
                                    <?php echo $review->customer; ?>
                                </div>
                            </div>
                            <div class="review-rating mb-1">
                                <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => true, 'rating' => (int) $review->review_rating, 'readonly' => true]); ?>
                            </div>
                            <div class="review-date text-muted mb-1">
                                <?php echo HTMLHelper::_('date', $review->created_on, vmText::_('DATE_FORMAT_LC')); ?>
                            </div>
                            <blockquote>
                                <?php echo $review->comment; ?>
                            </blockquote>
                        </div>

                        <?php if ($reviewsDisplayed >= $ratingsShow && !$this->showall) : ?>
                            <p>
                                <?php echo HTMLHelper::_('link', $this->more_reviews, vmText::_('COM_VIRTUEMART_MORE_REVIEWS'), ['class' => 'details', 'title' => vmText::_('COM_VIRTUEMART_MORE_REVIEWS')]); ?>
                            </p>
                            <?php break; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php else : ?>
            <p class="no-review-message"><?php echo vmText::_('COM_VIRTUEMART_NO_REVIEWS'); ?></p>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php $user = Factory::getApplication()->getIdentity(); ?>

<?php if ($user->guest && VmConfig::get('reviewMode', 'none') != 'none') : ?>
    <?php GlobalHelper::getInstance()->setData('showOffcanvasLogin', true); ?>

    <p class="review-login-message">
        <b><?php echo vmText::_('COM_VIRTUEMART_REVIEW_LOGIN'); ?></b>&nbsp;
        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLogin" aria-controls="offcanvasLogin"><?php echo vmText::_('JLOGIN'); ?></a>
    </p>
<?php endif; ?>
