<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app          = Factory::getApplication();
$template     = $app->getTemplate(true);
$document     = $app->getDocument();
$wa           = $document->getWebAssetManager();
$params       = $template->params;
$per_row_lg   = 4;
$per_row_md   = 3;
$per_row_sm   = 3;
$per_row_xs   = 2;
$lazyLoad     = $params->get('vm_image_lazyload', 1) ? 'true' : 'false';
$customfields = $this->product->customfieldsSorted['related_products'];
$firstField   = $customfields[0];

$script = <<<EOT
(function() {
    var initRelatedProductsSlider = function() {
        [].slice.call(document.querySelectorAll('.related-products__wrapper')).forEach(function (element) {
            tns({
                container: element,
                mouseDrag: true,
                autoplay: false,
                swipeAngle: false,
                slideBy: 'page',
                gutter: 28,
                speed: 400,
                loop: false,
                controlsText: [
                    '<i class="vpi vpi-chevron-left" aria-hidden="true"></i><span class="visually-hidden">Prev</span>',
                    '<i class="vpi vpi-chevron-right" aria-hidden="true"></i><span class="visually-hidden">Next</span>'
                ],
                controls: false,
                navPosition: 'bottom',
                items: {$per_row_xs},
                lazyload: {$lazyLoad},
                responsive: {
                    576: {
                        items: {$per_row_sm},
                    },
                    768: {
                        items: {$per_row_md},
                    },
                    992: {
                        items: {$per_row_lg},
                    },
                    1500: {
                        controls: true
                    }
                }
              })
        });
    }

    document.addEventListener('DOMContentLoaded', function () {
        initRelatedProductsSlider();

        if (typeof jQuery !== typeof undefined) {
            jQuery('body').on('updateVirtueMartProductDetail', function () {
                initRelatedProductsSlider();
            });
        }
    });
})();
EOT;

$wa->usePreset('tiny-slider');

vmJsApi::addJScript('related-product-slider', $script);
?>
<div class="product-related-products">
    <div class="header-group">
        <h3 class="product-related-title"><?php echo vmText::_($firstField->custom_title); ?></h3>
    </div>
    <div class="related-products__wrapper tns-initial-container">
        <?php foreach ($customfields as $customfield) : ?>
                <?php echo $customfield->display; ?>
        <?php endforeach; ?>
    </div>
</div>