<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app          = Factory::getApplication();
$template     = $app->getTemplate(true);
$params       = $template->params;
$itemsPerRow  = VmConfig::get('categories_per_row', 3);
$perRowLg     = $params->get('items_per_row_lg', '');
$itemsPerRow  = $perRowLg ? $perRowLg : $itemsPerRow;
$cellWidth[]  = 'col-lg-' . floor(12 / $itemsPerRow);
$perRowMd     = $params->get('items_per_row_md', 3);
$cellWidth[]  = 'col-md-' . floor(12 / $perRowMd);
$perRowSm     = $params->get('items_per_row_sm', 2);
$cellWidth[]  = 'col-sm-' . floor(12 / $perRowSm);
$perRowXs     = $params->get('items_per_row_xs', 2);
$cellWidth[]  = 'col-' . floor(12 / $perRowXs);
$cellWidth    = implode(' ', array_reverse($cellWidth));
$customfields = $this->product->customfieldsSorted['related_categories'];
$firstField   = $customfields[0];
?>
<div class="product-related-categories">
    <div class="header-group">
        <h3 class="product-related-title"><?php echo vmText::_($firstField->custom_title); ?></h3>
    </div>
    <div class="virtuemart-categories">
        <div class="row">
            <?php foreach ($customfields as $customfield) : ?>
                <div class="category d-flex <?php echo $cellWidth; ?>">
                    <?php echo $customfield->display; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>