<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$prevProduct = [
    'url'  => '',
    'name' => ''
];
$nextProduct = [
    'url'  => '',
    'name' => ''
];

if (!empty($this->product->neighbours ['previous'][0])) {
    $prevProduct['url']  = Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['previous'][0]['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id);
    $prevProduct['name'] = $this->product->neighbours ['previous'][0]['product_name'];
}

if (!empty($this->product->neighbours ['next'][0])) {
    $nextProduct['url']  = Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['next'][0]['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id);
    $nextProduct['name'] = $this->product->neighbours ['next'][0]['product_name'];
}
?>
<div class="product-navigation d-flex ms-auto ps-2 py-1">
    <?php if (!empty($prevProduct['url']) && !empty($prevProduct['name'])) : ?>
        <a href="<?php echo $prevProduct['url']; ?>" title="<?php echo $prevProduct['name']; ?>" class="previous-page p-1 has-tooltip" rel="prev" aria-label="<?php echo Text::_('JPREVIOUS'); ?>">
            <i class="fas fa-angle-left" aria-hidden="true"></i><span class="d-none d-md-inline">&nbsp;&nbsp;<?php echo Text::_('JPREVIOUS'); ?></span>
        </a>
    <?php endif; ?>

    <?php if (!empty($nextProduct['url']) && !empty($nextProduct['name'])) : ?>
        <a href="<?php echo $nextProduct['url']; ?>" title="<?php echo $nextProduct['name']; ?>" class="previous-page p-1 has-tooltip" rel="next" aria-label="<?php echo Text::_('JNEXT'); ?>">
            <span class="d-none d-md-inline"><?php echo Text::_('JNEXT'); ?>&nbsp;&nbsp;</span><i class="fas fa-angle-right" aria-hidden="true"></i>
        </a>
    <?php endif; ?>
</div>
