<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$model      = VmModel::getModel('manufacturer');
$template   = $app->getTemplate(true);
$params     = $template->params;
$lazyLoad   = $params->get('vm_image_lazyload', 1) && !$app->input->getInt('print', 0);
$imageClass = $lazyLoad ? 'manufacturer-image lazy' : 'manufacturer-image';
?>
<div class="product-manufacturers ms-auto ps-3 d-flex flex-column">
    <?php foreach ($this->product->virtuemart_manufacturer_id as $manufacturerId) : ?>
        <?php
        $manufacturer = $model->getManufacturer($manufacturerId);
        $model->addImages($manufacturer, 1);
        $thumbnail = VirtuemartHelper::prepareLazyImageHTML($manufacturer->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad, 10, 10, '#fff');

        if (strpos($thumbnail, (string) VmConfig::get('no_image_found')) !== false || strpos($thumbnail, (string) VmConfig::get('no_image_set')) !== false) {
            $thumbnail = $manufacturer->mf_name;
        }

        $url        = Route::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturerId);
        $buttonText = $manufacturer->mf_name;

        if ($params->get('manufacturer_link_to', 'products') === 'products') {
            $url         = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturerId);
            $buttonText  = vmText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $manufacturer->mf_name);
        }
        ?>
        <?php if ($params->get('show_manufacturer_modal', 0)) : ?>
            <div class="product-manufacturer">
                <a href="#manufacturer-modal-<?php echo $manufacturerId; ?>" class="manufacturer-modal-link" data-bs-toggle="modal"><?php echo $thumbnail; ?></a>
                <div class="modal fade" id="manufacturer-modal-<?php echo $manufacturerId ?>" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo $manufacturer->mf_name; ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo vmText::_('JLIB_HTML_BEHAVIOR_CLOSE'); ?>"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <?php if (!empty($thumbnail)) : ?>
                                    <div class="col-4">
                                        <?php echo $thumbnail; ?>
                                    </div>
                                    <?php endif; ?>
                                    <div class="<?php echo empty($thumbnail) ? 'col-12' : 'col-8';?>">
                                        <?php if (!empty($manufacturer->mf_desc)) : ?>
                                            <div class="mf-desc">
                                                <?php echo $manufacturer->mf_desc ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($manufacturer->mf_email)) : ?>
                                            <div class="mf-email">
                                                <?php echo $manufacturer->mf_email; ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($manufacturer->mf_url)) : ?>
                                            <div class="mf-url">
                                                <a href="<?php echo $manufacturer->mf_url; ?>" target="_blank"><?php echo $manufacturer->mf_url ?></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <a class="btn btn-primary" target="_top" href="<?php echo $url; ?>"><?php echo $buttonText ?></a>
                                <button class="btn btn-secondary" data-bs-dismiss="modal" aria-hidden="true"><?php echo vmText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else : ?>
            <div class="product-manufacturer">
                <a href="<?php echo $url; ?>" class="manufacturer-modal-link"><?php echo $thumbnail; ?></a>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>