<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app           = Factory::getApplication();
$template      = $app->getTemplate(true);
$params        = $template->params;
$document      = $app->getDocument();
$wa            = $document->getWebAssetManager();
$width         = VmConfig::get('img_width_full', 0);
$height        = VmConfig::get('img_height_full', 0);
$mouseoverZoom = $params->get('main_image_mouseover_zoom', 1);
$zoomFactor    = $params->get('main_image_mouseover_zoom_factor', 3);
$lazyLoad      = $params->get('vm_image_lazyload', 1) && !$app->input->getInt('print', 0);
$imageClass    = $lazyLoad ? 'product-image tns-lazy-img' : 'product-image';
$imageClassStd = $lazyLoad ? 'product-image lazy' : 'product-image';

$script = "
(function() {
    var productImageGallery = window.productImageGallery || {};
    
    productImageGallery.mainGalleryDefaultOptions = {
        container: '.product-image-gallery__main-multiple',
        navContainer: '.product-image-gallery__thumbnails',
        controlsContainer:  '.product-image-gallery__main-controls',
        navAsThumbnails: false,
        center: true,
        items: 1,
        autoHeight: false,
        mouseDrag: false,
        autoplay: false,
        speed: 400,
        loop: false,
        slideBy: 1,
        lazyload: " . ($lazyLoad ? 'true' : 'false') . ",
        992: {
            mouseDrag: true,
            swipeAngle: false
        }
    };
    
    productImageGallery.thumbnailGalleryDefaultOptions = {
        container: '.product-image-gallery__thumbnails',
        controlsContainer: '.product-image-gallery__thumbnails-controls',
        items: 4,
        mouseDrag: false,
        autoplay: false,
        autoHeight: false,
        speed: 400,
        nav: false,
        loop: false,
        slideBy: 1,
        gutter: 10,
        lazyload: " . ($lazyLoad ? 'true' : 'false') . ",
        responsive: {
            992: {
                items: 3,
                swipeAngle: false,
                gutter: 0,
                mouseDrag: true
            }
        }
    };
    
    productImageGallery.resizeTimeout = null;
    productImageGallery.tnsMainGallery = null;
    productImageGallery.tnsThumbnailGallery = null;
    productImageGallery.lightbox = null;
    productImageGallery.useMouseoverZoom = " . ($mouseoverZoom ? 'true' : 'false') . ";
    productImageGallery.drifts = [];
    productImageGallery.thumbnailGalleryTimeout = null;
    productImageGallery.windowWidth = null;
    productImageGallery.mainImageMaxHeight = 0;

    productImageGallery.initMain = function() {
        if (productImageGallery.lightbox) {
            productImageGallery.lightbox.destroy();
        }

        if (productImageGallery.useMouseoverZoom && productImageGallery.drifts.length) {
            productImageGallery.drifts.forEach(function (driftInstance) {
                driftInstance.destroy();
            });
        }

        if (productImageGallery.useMouseoverZoom && window.matchMedia('( min-width: 992px )').matches) {
            var driftInstance;

            [].slice.call(document.querySelectorAll('.product-image-gallery__main img')).forEach(function (img) {
                driftInstance = new Drift(img, {
                    inlinePane: true,
                    zoomFactor: " . $zoomFactor . ",
                    handleTouch: false
                });

                productImageGallery.drifts.push(driftInstance);
            });
        }

        [].slice.call(document.querySelectorAll('.product-gallery-lightbox')).forEach(function (element) {
            element.removeAttribute('title');
        });

        productImageGallery.lightbox = GLightbox({
            selector: '.product-gallery-lightbox',
            type: 'image',
            zoomable: true,
            draggable: true
        });
    }

    productImageGallery.destroyAllTnsGallery = function() {
        if (productImageGallery.tnsMainGallery) {
            productImageGallery.tnsMainGallery.destroy();
        }

        if (productImageGallery.tnsThumbnailGallery) {
            productImageGallery.tnsThumbnailGallery.destroy();
        }

        productImageGallery.mainImageMaxHeight = 0;
    }

    productImageGallery.initMainGallery = function() {
        if (productImageGallery.lightbox) {
            productImageGallery.lightbox.destroy();
        }

        if (productImageGallery.useMouseoverZoom && productImageGallery.drifts.length) {
            productImageGallery.drifts.forEach(function (driftInstance) {
                driftInstance.destroy();
            });
        }
        
        productImageGallery.tnsMainGallery = tns(productImageGallery.mainGalleryDefaultOptions);

        var info = productImageGallery.tnsMainGallery.getInfo();

        if (productImageGallery.mainGalleryDefaultOptions.lazyload) {
            [].slice.call(info.container.querySelectorAll('img')).forEach(function (img) {
                // img.removeEventListener('load', productImageGallery.onMainImageLoad);
                // img.addEventListener('load', productImageGallery.onMainImageLoad);
            });
        }

        if (productImageGallery.useMouseoverZoom && window.matchMedia('( min-width: 992px )').matches) {
            var driftInstance;

            [].slice.call(info.container.querySelectorAll('img')).forEach(function (img) {
                driftInstance = new Drift(img, {
                    inlinePane: true,
                    zoomFactor: " . $zoomFactor . ",
                    handleTouch: false
                });

                productImageGallery.drifts.push(driftInstance);
            });
        }

        productImageGallery.tnsMainGallery.events.on('indexChanged', function(info, eventName) {
            if (productImageGallery.tnsThumbnailGallery) {
                var thumbInfo = productImageGallery.tnsThumbnailGallery.getInfo();
                var inDisplay = false;
                
                for (var i = thumbInfo.index; i < thumbInfo.items; i++) {
                    if (info.index == i) {
                        inDisplay = true;
                        break;
                    }
                }

                if (!inDisplay) {
                    productImageGallery.tnsThumbnailGallery.goTo(info.index);
                }
            }
        });

        [].slice.call(document.querySelectorAll('.product-gallery-lightbox')).forEach(function (element) {
            element.removeAttribute('title');
        });

        productImageGallery.lightbox = GLightbox({
            selector: '.product-gallery-lightbox',
            type: 'image',
            zoomable: true,
            draggable: true,
            loop: true
        });
    }

    productImageGallery.initThumbnailGallery = function() {
        if (productImageGallery.thumbnailGalleryTimeout) {
            clearTimeout(productImageGallery.thumbnailGalleryTimeout);
        }

        productImageGallery.thumbnailGalleryTimeout = setTimeout(function() {
            productImageGallery._initThumbnailGallery();
        }, 50);
    }
    
    productImageGallery._initThumbnailGallery = function () {
        var options;
        
        if (window.matchMedia('( min-width: 992px )').matches) {
            options = {
                axis: 'vertical'
            }

            productImageGallery.setThumbnailGalleryInfo();
        } else {
            options = {
                axis: 'horizontal'
            }
        }
        
        productImageGallery.tnsThumbnailGallery = tns(Object.assign({}, productImageGallery.thumbnailGalleryDefaultOptions, options));
        
        var thumbInfo = productImageGallery.tnsThumbnailGallery.getInfo();

        if (productImageGallery.thumbnailGalleryDefaultOptions.lazyload && thumbInfo.container.classList.contains('tns-vertical')) {
            [].slice.call(thumbInfo.container.querySelectorAll('img')).forEach(function (img) {
                img.removeEventListener('load', productImageGallery.onThumbImageLoad);
                img.addEventListener('load', productImageGallery.onThumbImageLoad);
            });
        }
    }

    productImageGallery.setThumbnailGalleryInfo = function() {
        var mainWrapper = document.querySelector('.product-image-gallery__main-wrapper');
        var thumbnailWrapper = document.querySelector('.product-image-gallery__thumbnails-wrapper');

        if (mainWrapper && thumbnailWrapper) {
            thumbnailWrapper.style.setProperty('--product-gallery-vertical-height', mainWrapper.offsetHeight + 'px');
            thumbnailWrapper.style.setProperty('--product-gallery-vertical-items', productImageGallery.thumbnailGalleryDefaultOptions.responsive[992].items);
        }
    }

    productImageGallery.onThumbImageLoad = function() {
        window.dispatchEvent(new CustomEvent('resize', {detail: {isCustom: true}}));
    }

    productImageGallery.onMainImageLoad = function(event) {
        var info = productImageGallery.tnsMainGallery.getInfo();

        if (event.target && event.target.tagName == 'IMG' && event.target.height > productImageGallery.mainImageMaxHeight) {
            [].slice.call(info.container.querySelectorAll('.product-image-gallery__item-inner')).forEach(function (element) {
                element.style.setProperty('--template-product-main-image-min-height', event.target.height + 'px');
            });

            productImageGallery.mainImageMaxHeight = event.target.height;
        }
    }
    
    productImageGallery.resizeGalleries = function () {
        if (productImageGallery.resizeTimeout) {
            clearTimeout(productImageGallery.resizeTimeout);
        }
        
        productImageGallery.resizeTimeout = setTimeout(function () {
            productImageGallery.destroyAllTnsGallery();
            productImageGallery.initMainGallery();
            productImageGallery.initThumbnailGallery();
        }, 500);
    }

    productImageGallery.isWithMultipleImages = function() {
        if (document.querySelector(productImageGallery.mainGalleryDefaultOptions.container)) {
            return true;
        }

        return false;
    }
    
    document.addEventListener('DOMContentLoaded', function () {
        if (productImageGallery.isWithMultipleImages()) {
            productImageGallery.initMainGallery();
            productImageGallery.setThumbnailGalleryInfo();
            productImageGallery.initThumbnailGallery();
        } else {
            productImageGallery.initMain();
        }
        
        if (typeof jQuery !== typeof undefined) {
            jQuery('body').on('updateVirtueMartProductDetail', function () {
                if (productImageGallery.isWithMultipleImages()) {
                    productImageGallery.destroyAllTnsGallery();
                    productImageGallery.initMainGallery();
                    productImageGallery.setThumbnailGalleryInfo();
                    productImageGallery.initThumbnailGallery();
                } else {
                    productImageGallery.initMain();
                }
            });
        }

        productImageGallery.windowWidth = window.innerWidth;
    });
    
    window.addEventListener('orientationchange', function() {
        productImageGallery.setThumbnailGalleryInfo();

        if (productImageGallery.isWithMultipleImages()) {
            productImageGallery.resizeGalleries();
        }

        productImageGallery.windowWidth = window.innerWidth;
    });

    window.addEventListener('resize', function(event) {
        if (productImageGallery.windowWidth != window.innerWidth || window.matchMedia('( min-width: 992px )').matches) {
            productImageGallery.setThumbnailGalleryInfo();

            if (productImageGallery.isWithMultipleImages() && !(event instanceof CustomEvent)) {
                productImageGallery.resizeGalleries();
            }

            productImageGallery.windowWidth = window.innerWidth;
        }
    })
})();
";

$wa->usePreset('tiny-slider')
    ->usePreset('glightbox');

if ($mouseoverZoom) {
    $wa->usePreset('drift');
}

vmJsApi::addJScript('product-image-gallery', $script);
?>
<div class="product-image-gallery mb-5 mb-md-4 position-relative">
    <?php if (count($this->product->images) > 1) : ?>
        <div class="row">
            <div class="col-lg-9 order-lg-last">
                <div class="product-image-gallery__main-wrapper">
                    <figure class="product-image-gallery__main product-image-gallery__main-multiple is-tns-gallery">
                        <?php foreach ($this->product->images as $image) : ?>
                            <?php if (!empty($image) && is_object($image)) : ?>
                                <div class="product-image-gallery__item">
                                    <div class="product-image-gallery__item-inner">
                                        <?php if (!empty($width) || !empty($height)) : ?>
                                            <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaThumb(['class' => $imageClass, 'data-zoom' => Uri::root(true) . '/' . $image->file_url], true, 'class="product-gallery-lightbox" data-gallery="product-gallery-main"', true, false, false, $width, $height), $lazyLoad); ?>
                                        <?php else : ?>
                                            <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaFull(['class' => $imageClass, 'data-zoom' => Uri::root(true) . '/' . $image->file_url], true, 'class="product-gallery-lightbox"  data-gallery="product-gallery-main"', false), $lazyLoad); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </figure>
                    <div class="product-image-gallery__main-controls">
                        <button type="button" class="btn btn-nobg">
                            <i class="vpi vpi-chevron-left" aria-hidden="true"></i>
                            <span class="visually-hidden">Prev</span>
                        </button>
                        <button type="button" class="btn btn-nobg">
                            <i class="vpi vpi-chevron-right" aria-hidden="true"></i>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 order-lg-first">
                <div class="product-image-gallery__thumbnails-wrapper">
                    <div class="product-image-gallery__thumbnails is-tns-gallery">
                        <?php foreach ($this->product->images as $image) : ?>
                            <?php if (!empty($image) && is_object($image)) : ?>
                                <div class="product-image-gallery__item">
                                    <div class="product-image-gallery__item-inner">
                                        <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaThumb(['class' => $imageClass . ' product-image-thumbnail'], false), $lazyLoad); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <div class="product-image-gallery__thumbnails-controls">
                        <button type="button" class="btn btn-nobg">
                            <span class="d-none d-lg-inline-block" aria-hidden="true">
                                <i class="vpi vpi-chevron-up"></i>
                            </span>
                            <span class="d-lg-none" aria-hidden="true">
                                <i class="vpi vpi-chevron-left"></i>
                            </span>
                            <span class="visually-hidden">Prev</span>
                        </button>
                        <button type="button" class="btn btn-nobg">
                            <span class="d-none d-lg-inline-block" aria-hidden="true">
                                <i class="vpi vpi-chevron-down"></i>
                            </span>
                            <span class="d-lg-none" aria-hidden="true">
                                <i class="vpi vpi-chevron-right"></i>
                            </span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php else : ?>
        <div class="product-image-gallery__main-wrapper">
            <figure class="product-image-gallery__main product-image-gallery__main-single">
                <div class="product-image-gallery__item-inner">
                    <?php $image = reset($this->product->images); ?>
                    <?php if (!empty($width) || !empty($height)) : ?>
                        <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaThumb(['class' => $imageClassStd, 'data-zoom' => Uri::root(true) . '/' . $image->file_url], true, 'class="product-gallery-lightbox"', true, false, false, $width, $height), $lazyLoad); ?>
                    <?php else : ?>
                        <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaFull(['class' => $imageClassStd, 'data-zoom' => Uri::root(true) . '/' . $image->file_url], true, 'class="product-gallery-lightbox"', false), $lazyLoad); ?>
                    <?php endif; ?>
                </div>
            </figure>
        </div>
    <?php endif; ?>
    <?php echo shopFunctionsF::renderVmSubLayout('productlabels', ['product' => $this->product]); ?>
</div>