<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app       = Factory::getApplication();
$document  = $app->getDocument();
$wa        = $document->getWebAssetManager();
$link      = 'index.php?option=com_virtuemart&view=productdetails&tmpl=component&virtuemart_product_id=' . $this->product->virtuemart_product_id;
$mailLink  = Route::_('index.php?option=com_virtuemart&view=productdetails&task=recommend&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component');

$wa->useScript('bootstrap.dropdown');
?>
<?php if (VmConfig::get('show_emailfriend') || VmConfig::get('show_printicon') || VmConfig::get('pdf_icon')) : ?>
    <div class="product-page-icons ms-auto ps-2">
        <div class="dropdown">
            <a id="vmIcons" class="text-secondary" data-target="#" href="#" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="fas fa-cog"></span>
            </a>
            <ul class="dropdown-menu" role="menu" aria-labelledby="vmIcons">
                <?php if (VmConfig::get('pdf_icon')) : ?>
                    <li>
                        <a class="dropdown-item" href="<?php echo Route::_($link . '&format=pdf'); ?>" target="_blank">
                            <i class="fa fa-file-pdf"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_PDF'); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (VmConfig::get('show_printicon')) : ?>
                    <li>
                        <a class="dropdown-item" data-glightbox-link="true" href="<?php echo Route::_($link . '&print=1'); ?>">
                            <i class="fa fa-print"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_PRINT'); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (VmConfig::get('show_emailfriend')) : ?>
                    <li>
                        <a class="dropdown-item" data-glightbox-link="true" href="<?php echo $mailLink; ?>">
                            <i class="fa fa-share-alt"></i>&nbsp;&nbsp;<span><?php echo vmText::_('COM_VIRTUEMART_EMAIL'); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
<?php endif; ?>