<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$template   = $app->getTemplate(true);
$params     = $template->params;
$document   = $app->getDocument();
$print      = $app->input->getInt('print', 0);
$wa         = $document->getWebAssetManager();
$vmeEnabled = defined('VMESSENTIALS_ADMINISTRATOR');
$vmeParams  = ComponentHelper::getParams('com_vmessentials');

$wa->usePreset('tiny-slider')
    ->usePreset('glightbox')
    ->useScript('bootstrap.tab');
?>
<?php // If the product is not found?>
<?php if (empty($this->product)) : ?>
    <div class="alert alert-warning">
        <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND'); ?>
        <?php if (!empty($this->continue_link)) : ?>
            <br/><br/>
            <a href="<?php echo $this->continue_link; ?>" class="btn btn-warning btn-sm"><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?></a>
        <?php endif; ?>
    </div>
    <?php return; ?>
<?php endif; ?>

<?php
$askQuestionUrl = Route::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component');
$backPageUrl    = Route::_('index.php?option=com_virtuemart');
$backPageName   = vmText::_('COM_VIRTUEMART_SHOP_HOME');

if ($this->product->virtuemart_category_id > 1) {
    $backPageUrl  = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $this->product->virtuemart_category_id);
    $backPageName = vmText::_($this->product->category_name);
}

$backPageLink = HTMLHelper::_('link', $backPageUrl, $backPageName, ['class' => 'back-page link-body-invert']);

if (!property_exists($this->product, 'customfieldsSorted')) {
    $this->product->customfieldsSorted = [];
}

$this->productDisplayShipments = VirtuemartHelper::getCleanDisplayContent($this->productDisplayShipments);
$this->productDisplayPayments  = VirtuemartHelper::getCleanDisplayContent($this->productDisplayPayments);

if (VmConfig::get('product_navigation', 1) && !$print) {
    GlobalHelper::getInstance()->setData('product-navigation', $this->loadTemplate('navigation'));
}
?>
<div class="productdetails-view productdetails" data-vm="product-container">
    <div class="row mb-5" data-vm="product-child-container">
        <?php if (!empty($this->product->images)) : ?>
            <div class="col-md-6">
                <?php echo $this->loadTemplate('images'); ?>
            </div>
        <?php endif; ?>
        <div class="<?php echo !empty($this->product->images) ? 'col-md-6' : 'col-12'; ?>">
            <div class="product-title-container d-flex align-items-center <?php echo $this->showRating ? 'mb-2' : 'mb-4'; ?>">
                <h1 class="product-page-title flex-fill mt-0 mb-0"><?php echo $this->product->product_name; ?></h1>
                <?php if (!$print) : ?>
                    <?php echo $this->edit_link; ?>
                    <?php echo $this->loadTemplate('icons'); ?>
                <?php endif; ?>
            </div>
            <?php if ($this->showRating) : ?>
                <div class="product-rating mb-4">
                    <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $this->showRating, 'product' => $this->product, 'readonly' => true, 'showCount' => true]); ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($this->product->event->afterDisplayTitle)) : ?>
                <div class="event-afterDisplayTitle">
                    <?php echo $this->product->event->afterDisplayTitle; ?>
                </div>
            <?php endif; ?>
            <div class="product-overview-container d-flex mb-4">
                <div class="product-prices-sku-mpn-gtin-stock flex-fill">
                    <div class="product-prices-wrapper mb-4">
                        <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $this->product, 'currency' => $this->currency, 'showDetails' => $params->get('show_all_prices', 0)]); ?>
                    </div>
                    <div class="row">
                        <div class="product-stock col-5 col-sm-6">
                            <?php if (VmConfig::get('display_stock', 1)) : ?>
                                <?php echo shopFunctionsF::renderVmSubLayout('stock', ['product' => $this->product]); ?>
                            <?php endif; ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('stockhandle', ['product' => $this->product]); ?>
                        </div>
                        <div class="col-7 col-sm-6">
                            <?php if ($params->get('show_sku', 1) && !empty($this->product->product_sku)) : ?>
                                <div class="product-sku">
                                    <span><?php echo vmText::_('COM_VIRTUEMART_CART_SKU'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_sku; ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if ($params->get('show_mpn', 0) && !empty($this->product->product_mpn)) : ?>
                                <div class="product-mpn">
                                    <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_MPN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_mpn; ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if ($params->get('show_gtin', 1) && !empty($this->product->product_gtin)) : ?>
                                <div class="product-gtin">
                                    <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_GTIN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_gtin; ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($this->product->product_box)) : ?>
                                <div class="product-box">
                                    <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX'); ?></span><span class="text-muted"><?php echo $this->product->product_box; ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if (VmConfig::get('show_manufacturers', 1)) : ?>
                    <?php echo $this->loadTemplate('manufacturer'); ?>
                <?php endif; ?>
            </div>
            <?php if (!empty($this->product->product_s_desc)) : ?>
                <?php if ($this->product->product_s_desc != strip_tags($this->product->product_s_desc)) : ?>
                    <div class="product-short-description mb-4">
                        <?php echo $this->product->product_s_desc; ?>
                    </div>
                <?php else : ?>
                    <p class="product-short-description mb-4">
                        <?php echo nl2br($this->product->product_s_desc); ?>
                    </p>
                <?php endif; ?>
            <?php endif; ?>
            <?php if (!empty($this->product->customfieldsSorted['ontop'])) : ?>
                <div class="ontop-fields-container mb-4">
                    <?php echo shopFunctionsF::renderVmSubLayout('customfields', ['product' => $this->product, 'position' => 'ontop']); ?>
                </div>
            <?php endif; ?>
            <?php if (is_array($this->productDisplayShipments) && !empty($this->productDisplayShipments)) : ?>
                <div class="productDisplayShipments mb-4">
                    <?php foreach ($this->productDisplayShipments as $productDisplayShipment) : ?>
                        <?php foreach ($productDisplayShipment as $methodId => $productShipmentHtml) : ?>
                            <div class="product-display-shipment product-display-shipment-<?php echo $methodId ?> mb-2">
                                <?php echo $productShipmentHtml; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <div class="add-to-cart-container mb-4">
                <?php echo shopFunctionsF::renderVmSubLayout('addtocart', ['product' => $this->product]); ?>
            </div>
            <?php if ($vmeEnabled && ($vmeParams->get('enable_wishlist', 1) || $vmeParams->get('enable_compare', 1))) : ?>
                <div class="product-utilities-container mb-4">
                    <?php if ($vmeParams->get('enable_wishlist', 1)) : ?>
                        <div class="product-utility-item">
                            <?php echo HTMLHelper::_('vmessentials.addtowishlist', $this->product, false); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($vmeParams->get('enable_compare', 1)) : ?>
                        <div class="product-utility-item">
                            <?php echo HTMLHelper::_('vmessentials.addtocompare', $this->product, false); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if (is_array($this->productDisplayPayments) && !empty($this->productDisplayPayments)) : ?>
                <div class="separator-line mb-4" aria-hidden="true" tabindex="-1"></div>
                <div class="productDisplayPayments mb-4">
                    <?php foreach ($this->productDisplayPayments as $productDisplayPayment) : ?>
                        <?php foreach ($productDisplayPayment as $methodId => $productDisplayHtml) : ?>
                            <div class="product-display-payment product-display-payment-<?php echo $methodId ?> mb-2">
                                <?php echo $productDisplayHtml; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <?php if (!$print) : ?>
                <div class="separator-line mb-4" aria-hidden="true" tabindex="-1"></div>
                <div class="product-links-container">
                    <?php if (VmConfig::get('ask_question', 0)) : ?>
                        <div class="ask-a-question-wrapper mb-3">
                            <a class="ask-a-question link-body-invert" href="<?php echo $askQuestionUrl; ?>" rel="nofollow" data-glightbox-link="true">
                                <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ENQUIRY_LBL'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="product-back-link-wrapper mb-3">
                        <?php echo vmText::sprintf('COM_VIRTUEMART_CATEGORY_BACK_TO', $backPageLink); ?>
                    </div>
                </div>
                <?php if ($params->get('show_social_share', 1)) : ?>
                    <div class="social-share-icons">
                        <?php echo shopFunctionsF::renderVmSubLayout('productshare', ['product' => $this->product]); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
    <?php if (!empty($this->product->event->beforeDisplayContent)) : ?>
        <div class="separator-line mb-5" aria-hidden="true" tabindex="-1"></div>
        <div class="event-beforeDisplayContent mb-4">
            <?php echo $this->product->event->beforeDisplayContent; ?>
        </div>
    <?php endif; ?>
    <div class="separator-line separator-line-above-tabs mb-5" aria-hidden="true" tabindex="-1"></div>
    <?php echo $this->loadTemplate('tabs'); ?>
    <?php if (!empty($this->product->customfieldsSorted['onbot'])) : ?>
        <div class="separator-line mb-5" aria-hidden="true" tabindex="-1"></div>
        <div class="onbot-fields-container mb-4">
            <?php echo shopFunctionsF::renderVmSubLayout('customfields', ['product' => $this->product, 'position' => 'onbot']); ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($this->product->customfieldsSorted['related_products'])) : ?>
        <div class="separator-line mb-5" aria-hidden="true" tabindex="-1"></div>
        <div class="related_products-fields-container mb-4">
            <?php echo $this->loadTemplate('relatedproducts'); ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($this->product->customfieldsSorted['related_categories'])) : ?>
        <div class="separator-line mb-5" aria-hidden="true" tabindex="-1"></div>
        <div class="related_categories-fields-container mb-4">
            <?php echo $this->loadTemplate('relatedcategories'); ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($this->product->event->afterDisplayContent)) : ?>
        <div class="separator-line mb-5" aria-hidden="true" tabindex="-1"></div>
        <div class="event-afterDisplayContent mb-4">
            <?php echo $this->product->event->afterDisplayContent; ?>
        </div>
    <?php endif; ?>
    <?php if ($this->cat_productdetails) : ?>
        <?php echo $this->loadTemplate('showcategory'); ?>
    <?php endif; ?>
    
    <?php echo $this->loadTemplate('scripts'); ?>

    <?php if ($this->product->prices['salesPrice'] > 0) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout('snippets', ['product' => $this->product, 'currency' => $this->currency, 'showRating' => $this->showRating]); ?>
    <?php endif; ?>
</div>
