<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$document    = $app->getDocument();
$wa          = $document->getWebAssetManager();
$ajaxUpdate  = VmConfig::get('ajax_order', true) ? ' data-dynamic-update="1"' : '';

$wa->usePreset('glightbox');
$wa->useScript('bootstrap.tab');
?>
<div class="vm-orders-list-view">
    <div class="vm-orders-information" aria-hidden="true"></div>
    <div class="vm-orders-list">
        <div class="page-header">
            <h1><?php echo vmText::_('COM_VIRTUEMART_ORDERS_VIEW_DEFAULT_TITLE'); ?></h1>
        </div>
        <?php if (empty($this->orderlist)) : ?>
            <?php echo shopFunctionsF::getLoginForm(false, $this->trackingByOrderPass); ?>
        <?php else : ?>
            <div class="table-responsive mb-4">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th class="align-left">
                                <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_ORDER_NUMBER'); ?>
                            </th>
                            <th class="align-center">
                                <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_CDATE'); ?>
                            </th>
                            <th class="align-center d-none d-md-table-cell">
                                <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_MDATE'); ?>
                            </th>
                            <th class="align-center">
                                <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_STATUS'); ?>
                            </th>
                            <th class="align-right">
                                <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_TOTAL'); ?>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($this->orderlist as $row) : ?>
                            <tr>
                                <td class="align-left">
                                    <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $row->order_number); ?>" <?php echo $ajaxUpdate; ?> rel="nofollow">
                                        <?php echo $row->order_number; ?>
                                    </a>
                                </td>
                                <td class="align-center">
                                    <?php echo HTMLHelper::_('date', $row->created_on); ?>
                                </td>
                                <td class="align-center hidden-xs">
                                    <?php echo HTMLHelper::_('date', $row->modified_on); ?>
                                </td>
                                <td class="align-center">
                                    <?php echo shopFunctionsF::getOrderStatusName($row->order_status); ?>
                                </td>
                                <td class="align-right nowrap">
                                    <?php echo $this->currency->priceDisplay($row->order_total, $row->currency); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php if (VmConfig::get('ajax_order', true)) : ?>
    <?php vmJsApi::jDynUpdate('.vm-orders-information'); ?>
<?php endif; ?>