<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>
<table class="table table-borderless table-sm mb-5">
    <tbody>
        <tr>
            <th class="field-name text-nowrap w-25 ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_NUMBER'); ?>
            </th>
            <td>
                <?php echo $this->orderdetails['details']['BT']->order_number; ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_DATE'); ?>
            </th>
            <td>
                <?php echo vmJsApi::date($this->orderdetails['details']['BT']->created_on, 'LC4', true); ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_STATUS'); ?>
            </th>
            <td>
                <?php echo $this->orderstatuses[$this->orderdetails['details']['BT']->order_status]; ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_LAST_UPDATED'); ?>
            </th>
            <td>
                <?php echo vmJsApi::date($this->orderdetails['details']['BT']->modified_on, 'LC4', true); ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIPMENT_LBL'); ?>
            </th>
            <td>
                <?php echo $this->shipment_name; ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PAYMENT_LBL'); ?>
            </th>
            <td><?php echo $this->payment_name; ?></td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_CUSTOMER_NOTE'); ?>
            </th>
            <td>
                <?php echo $this->orderdetails['details']['BT']->customer_note; ?>
            </td>
        </tr>
        <tr>
            <th class="field-name text-nowrap ps-0">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL'); ?>
            </th>
            <td>
                <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_total, $this->currency); ?>
            </td>
        </tr>
    </tbody>
</table>
<div class="row">
    <?php $btClass = !empty($this->shipmentfields['fields']) ? 'col-sm-6' : 'col-sm-12'; ?>
    <div class="<?php echo $btClass; ?>">
        <fieldset>
            <legend>
                <b><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_BILL_TO_LBL'); ?></b>
            </legend>
            <table class="table table-borderless table-sm">
                <tbody>
                    <?php foreach ($this->userfields['fields'] as $field) : ?>
                        <?php if (!empty($field['value'])) : ?>
                            <tr>
                                <th class="width50 field-name ps-0">
                                    <?php echo $field['title']; ?>
                                </th>
                                <td>
                                    <?php echo $field['value']; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </fieldset>
    </div>
    <?php if (!empty($this->shipmentfields['fields'])) : ?>
        <div class="col-sm-6">
            <fieldset>
                <legend>
                    <b><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIP_TO_LBL'); ?></b>
                </legend>
                <table class="table table-borderless table-sm">
                    <tbody>
                        <?php if (!empty($this->orderdetails['details']['has_ST'])) : ?>
                            <?php foreach ($this->shipmentfields['fields'] as $field) : ?>
                                <?php if (!empty($field['value'])) : ?>
                                    <tr>
                                        <th class="width50 field-name ps-0">
                                            <?php echo $field['title']; ?>
                                        </th>
                                        <td>
                                            <?php echo $field['value']; ?>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td class="ps-0">
                                    <?php echo vmText::_('COM_VM_ST_SAME_AS_BT'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </fieldset>
        </div>
    <?php endif; ?>
</div>
