<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;
?>
<?php if ($this->format != 'pdf' && !$this->print) : ?>
    <div class="table-responsive">
<?php endif; ?>

<table class="table table-striped table-sm align-top">
    <thead>
        <tr>
            <th width="5%" class="text-start">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SKU') ?>
            </th>
            <th width="25%" class="text-start">
                <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NAME_TITLE') ?>
            </th>
            <th width="15%" class="text-center">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_STATUS') ?>
            </th>
            <th width="10%" class="text-end">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRICE') ?>
            </th>
            <th width="5%" class="text-center">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_QTY') ?>
            </th>
            <?php if (VmConfig::get('show_tax')) : ?>
                <th width="10%" class="text-end">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_TAX') ?>
                </th>
            <?php endif; ?>
            <th width="11%" class="text-end">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SUBTOTAL_DISCOUNT_AMOUNT') ?>
            </th>
            <th width="10%" class="text-end">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?>
            </th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($this->orderdetails['items'] as $item) : ?>
            <?php
            $qtt   = $item->product_quantity ;
            $_link = Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_category_id=' . $item->virtuemart_category_id . '&virtuemart_product_id=' . $item->virtuemart_product_id);
            ?>
            <tr>
                <td class="text-start align-top">
                    <?php echo $item->order_item_sku; ?>
                </td>
                <td class="text-start align-top">
                    <div class="ordered-product-name mb-2">
                        <a href="<?php echo $_link; ?>" class="link-body" title="<?php echo $item->order_item_name; ?>"><?php echo $item->order_item_name; ?></a>
                    </div>
                    <?php echo VirtueMartModelCustomfields::CustomsFieldOrderDisplay($item, 'FE'); ?>
                </td>
                <td class="text-center align-top">
                    <?php echo $this->orderstatuses[$item->order_status]; ?>
                </td>
                <td class="priceCol text-end align-top text-nowrap">
                    <?php $item->product_discountedPriceWithoutTax = (float) $item->product_discountedPriceWithoutTax; ?>
                    <?php if (!empty($item->product_priceWithoutTax) && $item->product_discountedPriceWithoutTax != $item->product_priceWithoutTax) : ?>
                        <?php echo '<s>' . $this->currency->priceDisplay($item->product_item_price, $this->currency) . '</s><br />'; ?>
                        <?php echo $this->currency->priceDisplay($item->product_discountedPriceWithoutTax, $this->currency); ?>
                    <?php else : ?>
                        <?php echo $this->currency->priceDisplay($item->product_item_price, $this->currency); ?>
                    <?php endif; ?>
                </td>
                <td class="text-center align-top">
                    <?php echo $qtt; ?>
                </td>
                <?php if (VmConfig::get('show_tax')) : ?>
                    <td class="priceCol text-end text-nowrap align-top">
                        <?php echo $this->currency->priceDisplay($item->product_tax, $this->currency, $qtt); ?>
                    </td>
                <?php endif; ?>
                <td class="priceCol text-end text-nowrap align-top">
                    <?php echo $this->currency->priceDisplay($item->product_subtotal_discount, $this->currency);  ?>
                </td>
                <td class="priceCol text-end text-nowrap align-top">
                    <?php $item->product_basePriceWithTax = (float) $item->product_basePriceWithTax; ?>
                    <?php if (!empty($item->product_basePriceWithTax) && $item->product_basePriceWithTax != $item->product_final_price) : ?>
                        <?php echo '<s>' . $this->currency->priceDisplay($item->product_basePriceWithTax, $this->currency, $qtt) . '</s><br/>' ; ?>
                    <?php elseif (empty($item->product_basePriceWithTax) && $item->product_item_price != $item->product_final_price) : ?>
                        <?php echo '<s>' . $this->currency->priceDisplay($item->product_item_price, $this->currency, $qtt) . '</s><br/>'; ?>
                    <?php endif; ?>
                    <?php echo $this->currency->priceDisplay($item->product_subtotal_with_tax, $this->currency); ?> 
                </td>
            </tr>
        <?php endforeach; ?>
        <tr>
            <td colspan="5" class="text-end">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_PRICES_TOTAL'); ?>
            </td>
            <?php if (VmConfig::get('show_tax')) : ?>
                <td class="text-end text-nowrap">
                    <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_tax, $this->currency) ?>
                </td>
            <?php endif; ?>
            <td class="text-end text-nowrap">
                <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_discountAmount, $this->currency) ?>
            </td>
            <td class="text-end text-nowrap">
                <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_salesPrice, $this->currency) ?>
            </td>
        </tr>
        
        <?php if ($this->orderdetails['details']['BT']->coupon_discount <> 0.00) : ?>
            <?php $coupon_code = $this->orderdetails['details']['BT']->coupon_code ? ' (' . $this->orderdetails['details']['BT']->coupon_code . ')' : ''; ?>
            <tr>
                <td class="pricePad text-end" colspan="5">
                    <?php echo vmText::_('COM_VIRTUEMART_COUPON_DISCOUNT') . $coupon_code ?>
                </td>
                <?php if (VmConfig::get('show_tax')) : ?>
                    <td>&nbsp;</td>
                <?php endif; ?>
                <td>&nbsp;</td>
                <td class="text-end text-nowrap">
                    <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->coupon_discount, $this->currency); ?>
                </td>
            </tr>
        <?php endif; ?>

        <?php foreach ($this->orderdetails['calc_rules'] as $rule) : ?>
            <?php if ($rule->calc_kind == 'DBTaxRulesBill') : ?>
                <tr>
                    <td colspan="5" class="pricePad text-end">
                        <?php echo $rule->calc_rule_name ?>
                    </td>
                    <?php if (VmConfig::get('show_tax')) : ?>
                        <td>&nbsp;</td>
                    <?php endif; ?>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                    </td>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                    </td>
                </tr>
            <?php elseif ($rule->calc_kind == 'taxRulesBill') : ?>
                <tr>
                    <td colspan="5" class="pricePad text-end">
                        <?php echo $rule->calc_rule_name ?>
                    </td>
                    <?php if (VmConfig::get('show_tax')) : ?>
                        <td class="text-end text-nowrap">
                            <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                        </td>
                    <?php endif; ?>
                    <td>&nbsp;</td>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                    </td>
                </tr>
            <?php elseif ($rule->calc_kind == 'DATaxRulesBill') : ?>
                <tr>
                    <td colspan="5" class="pricePad text-end">
                        <?php echo $rule->calc_rule_name ?>
                    </td>
                    <?php if (VmConfig::get('show_tax')) : ?>
                        <td>&nbsp;</td>
                    <?php endif; ?>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                    </td>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; ?>

        <tr>
            <td class="pricePad text-end" colspan="5">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIPPING') ?>
            </td>
            <?php if (VmConfig::get('show_tax')) : ?>
                <td class="text-end text-nowrap">
                    <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_shipment_tax, $this->currency) ?>
                </td>
            <?php endif; ?>
            <td>&nbsp;</td>
            <td class="text-end text-nowrap">
                <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_shipment + $this->orderdetails['details']['BT']->order_shipment_tax, $this->currency); ?>
            </td>
        </tr>

        <tr>
            <td class="pricePad text-end" colspan="5">
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PAYMENT'); ?>
            </td>
            <?php if (VmConfig::get('show_tax')) : ?>
                <td class="text-end text-nowrap">
                    <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_payment_tax, $this->currency) ?>
                </td>
            <?php endif; ?>
            <td>&nbsp;</td>
            <td class="text-end text-nowrap">
                <?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_payment + $this->orderdetails['details']['BT']->order_payment_tax, $this->currency); ?>
            </td>
        </tr>

        <tr>
            <td class="pricePad text-end" colspan="5">
                <strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></strong>
            </td>
            <?php if (VmConfig::get('show_tax')) :  ?>
                <td class="text-end text-nowrap">
                    <strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_billTaxAmount, $this->currency); ?></strong>
                </td>
            <?php endif; ?>
            <td class="text-end text-nowrap">
                <strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_billDiscountAmount, $this->currency); ?></strong>
            </td>
            <td class="text-end text-nowrap">
                <strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_total, $this->currency); ?></strong>
            </td>
        </tr>

        <?php $totalColSpan = VmConfig::get('show_tax') ? 8 : 7; ?>

        <tr>
            <td colspan="<?php echo $totalColSpan; ?>">&nbsp;</td>
        </tr>

        <?php $this->orderbt  = $this->orderdetails['details']['BT']; ?>
        <?php $paymentDetails = false; ?>

        <?php if (empty($this->orderbt->paid)) : ?>
            <?php $paymentStatus = vmText::_('COM_VM_ORDER_UNPAID'); ?>
        <?php elseif (round($this->orderbt->paid, $this->currency->_priceConfig['salesPrice'][1]) == round($this->orderbt->toPay, $this->currency->_priceConfig['salesPrice'][1])) : ?>
            <?php $paymentStatus = vmText::_('COM_VM_ORDER_PAID'); ?>
        <?php elseif (round($this->orderbt->paid, $this->currency->_priceConfig['salesPrice'][1]) < round($this->orderbt->toPay, $this->currency->_priceConfig['salesPrice'][1])) : ?>
            <?php $paymentStatus  = vmText::sprintf('COM_VM_ORDER_PARTIAL_PAID', $this->orderbt->paid); ?>
            <?php $paymentDetails = true; ?>
        <?php else : ?>
            <?php $paymentStatus  = vmText::sprintf('COM_VM_ORDER_CREDIT_BALANCE', $this->orderbt->paid); ?>
            <?php $paymentDetails = true; ?>
        <?php endif; ?>

        <tr>
            <td colspan="2">
                <strong><?php echo vmText::_('COM_VM_ORDER_BALANCE'); ?></strong>
            </td>
            <?php if (empty($this->toRefund) && !$paymentDetails) : ?>
                <td colspan="<?php echo ($totalColSpan - 2); ?>">
                    <?php echo $paymentStatus; ?>
                </td>
            <?php endif; ?>
        </tr>

        <?php if (!empty($this->toRefund)) : ?>
            <tr>
                <td colspan="<?php echo $totalColSpan; ?>">
                    <strong><?php echo vmText::_('COM_VM_ORDER_PRODUCTS_TO_REFUND'); ?></strong>
                </td>
            </tr>

            <?php foreach ($this->toRefund as $index => $item) : ?>
                <tr>
                    <td>
                        <?php echo $item->order_item_sku; ?>
                    </td>
                    <td>
                        <?php echo $item->order_item_name; ?>
                    </td>
                    <td colspan="3"></td>
                    <?php if (VmConfig::get('show_tax')) :  ?>
                        <td class="text-end text-nowrap">
                            <?php echo $this->currency->priceDisplay($item->product_tax); ?>
                        </td>
                    <?php endif; ?>
                    <td></td>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($item->product_subtotal_with_tax); ?>
                    </td>
                </tr>
                <?php $this->orderbt->order_total -= $item->product_subtotal_with_tax; ?>
            <?php endforeach; ?>
        <?php endif; ?>

        <?php if (!empty($this->toRefund) || $paymentDetails) : ?>
            <?php if (round($this->orderbt->paid, $this->currency->_priceConfig['salesPrice'][1]) < round($this->orderbt->toPay, $this->currency->_priceConfig['salesPrice'][1])) : ?>
                <?php if (empty($this->orderbt->paid)) : ?>
                    <?php $statusText = vmText::_('COM_VM_ORDER_UNPAID'); ?>
                <?php else : ?>
                    <?php $statusText =  vmText::_('COM_VM_ORDER_PARTIAL_PAID'); ?>
                <?php endif; ?>

                <?php $balanceText = vmText::_('COM_VM_ORDER_OUTSTANDING_AMOUNT'); ?>
            <?php else : ?>
                <?php $statusText =  vmText::_('COM_VM_ORDER_PAID'); ?>
                <?php $balanceText = vmText::_('COM_VM_ORDER_BALANCE'); ?>
            <?php endif; ?>

            <?php if ($this->orderbt->toPay != $this->orderbt->order_total) : ?>
                <tr>
                    <td colspan="5" class="text-end">
                        <?php echo vmText::_('COM_VM_ORDER_NEW_TOTAL'); ?>
                    </td>
                    <?php if (VmConfig::get('show_tax')) :  ?>
                        <td></td>
                    <?php endif; ?>
                    <td></td>
                    <td class="text-end text-nowrap">
                        <?php echo $this->currency->priceDisplay($this->orderbt->toPay); ?>
                    </td>
                </tr>
            <?php endif; ?>

            <tr>
                <td colspan="5" class="text-end">
                    <?php echo $statusText; ?>
                </td>
                <?php if (VmConfig::get('show_tax')) :  ?>
                    <td></td>
                <?php endif; ?>
                <td></td>
                <td class="text-end text-nowrap">
                    <?php echo $this->currency->priceDisplay($this->orderbt->paid); ?>
                </td>
            </tr>

            <tr>
                <td colspan="5" class="text-end">
                    <strong><?php echo $balanceText; ?></strong>
                </td>
                <?php if (VmConfig::get('show_tax')) :  ?>
                    <td></td>
                <?php endif; ?>
                <td></td>
                <td class="text-end text-nowrap">
                    <strong><?php echo $this->currency->priceDisplay(abs($this->orderbt->order_total - $this->orderbt->paid)); ?></strong>
                </td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
    
<?php if ($this->format != 'pdf'  && !$this->print) : ?>
    </div>
<?php endif; ?>