<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>
<?php if ($this->format != 'pdf' && !$this->print) : ?>
    <div class="table-responsive">
<?php endif; ?>

<table class="table table-striped table-sm">
    <thead>
        <tr>
            <th>
                <?php echo vmText::_('COM_VIRTUEMART_DATE'); ?>
            </th>
            <th>
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_STATUS'); ?>
            </th>
            <th>
                <?php echo vmText::_('COM_VIRTUEMART_ORDER_COMMENT'); ?>
            </th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($this->orderdetails['history'] as $history) : ?>
            <?php if ($history->customer_notified) : ?>
                <tr>
                    <td>
                        <?php echo vmJsApi::date($history->created_on, 'LC2', true); ?>
                    </td>
                    <td>
                        <?php echo $this->orderstatuses[$history->order_status_code]; ?>
                    </td>
                    <td>
                        <?php echo $history->comments; ?>
                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; ?>
    </tbody>
</table>

<?php if ($this->format != 'pdf'  && !$this->print) : ?>
    </div>
<?php endif; ?>
