<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$document    = $app->getDocument();
$wa          = $document->getWebAssetManager();
$invoiceInfo = ['url' => null, 'number' => null];

$wa->usePreset('glightbox');
$wa->useScript('bootstrap.tab');

if (!empty($this->orderdetails) && !$this->print) {
    $this->orderdetails['details']['BT']->invoiceNumber = VmModel::getModel('orders')->getInvoiceNumber($this->orderdetails['details']['BT']->virtuemart_order_id);

    $orderInfo = $this->orderdetails['details']['BT'];

    if (!empty($orderInfo->invoiceNumber)) {
        if ($safePath = shopFunctions::getSafePathFor($orderInfo->virtuemart_vendor_id, 'invoice')) {
            $invoiceFile = $safePath . DIRECTORY_SEPARATOR . shopFunctionsF::getInvoiceName($orderInfo->invoiceNumber) . '.pdf';

            if (file_exists($invoiceFile)) {
                $invoiceInfo['url']    = Uri::root(true) . '/index.php?option=com_virtuemart&view=invoice&layout=invoice&format=pdf&tmpl=component&order_number=' . $orderInfo->order_number . '&order_pass=' . $orderInfo->order_pass;
                $invoiceInfo['number'] = $orderInfo->invoiceNumber;
            }
        }
    }
}
?>
<div class="vm-order-details-view">
    <?php if (empty($this->orderdetails)) : ?>
        <?php echo shopFunctionsF::getLoginForm(false, $this->trackingByOrderPass); ?>
    <?php elseif ($this->print) : ?>
        <div class="order-details-print p-1">
            <div class="row mb-4">
                <div class="col-6">
                    <h2><?php echo $this->vendor->vendor_store_name; ?></h2>
                    <p><?php echo $this->vendor->vendor_name . (!empty($this->vendor->vendor_phone) ? ' - ' . $this->vendor->vendor_phone : ''); ?></p>
                </div>
                <div class="col-6">
                    <div class="order-details-print__vendor-image text-end">
                        <img src="<?php echo Uri::root() . $this->vendor->images[0]->file_url; ?>" alt="<?php echo $this->vendor->vendor_store_name; ?>" />
                    </div>
                </div>
            </div>
            <h1 class="fs-3"><?php echo vmText::_('COM_VIRTUEMART_ACC_ORDER_INFO'); ?></h1>
            <div class="separator-line mb-3" aria-hidden="true" tabindex="-1"></div>
            <div class="order-details-print__header mb-3">
                <?php echo $this->loadTemplate('order'); ?>
            </div>
            <div class="order-details-print__items mb-3">
                <?php echo $this->loadTemplate('items'); ?>
            </div>
            <div class="order-details-print__footer">
                <?php echo VirtuemartViewInvoice::replaceVendorFields($this->vendor->vendor_letter_footer_html, $this->vendor); ?>
            </div>
        </div>
    <?php else : ?>
        <div class="vm-orders-information">
            <div class="page-header d-flex gap-3 align-items-start">
                <h1><?php echo vmText::_('COM_VIRTUEMART_ACC_ORDER_INFO'); ?></h1>
                <div class="d-flex gap-3 ms-auto mt-2">
                    <?php if (!empty($this->details_url)) : ?>
                        <a href="<?php echo Route::_($this->details_url . '&print=1'); ?>" class="link-body-invert has-tooltip" title="<?php echo vmText::_('COM_VIRTUEMART_PRINT') ?>" data-glightbox-link="true">
                            <i class="fas fa-print fa-lg" aria-hidden="true"></i>
                            <span class="visually-hidden"><?php echo vmText::_('COM_VIRTUEMART_PRINT'); ?></span>
                        </a>
                    <?php endif; ?>
                    <?php if (!empty($invoiceInfo['url'])) : ?>
                        <a href="<?php echo $invoiceInfo['url']; ?>" class="link-body-invert has-tooltip" title="<?php echo vmText::_('COM_VIRTUEMART_INVOICE') ?>">
                            <i class="far fa-file-pdf fa-lg" aria-hidden="true"></i>
                            <span class="visually-hidden"><?php echo vmText::_('COM_VIRTUEMART_INVOICE'); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <?php if ($this->order_list_link) : ?>
                <div class="mb-3 text-end">
                    <a href="<?php echo $this->order_list_link ?>" rel="nofollow" class="link-body-invert">
                        <i class="fas fa-bars" aria-hidden="true"></i>&nbsp;&nbsp;<?php echo vmText::_('COM_VIRTUEMART_ORDERS_VIEW_DEFAULT_TITLE'); ?>
                    </a>
                </div>
            <?php endif; ?>

            <div class="order-details__header mb-4">
                <?php echo $this->loadTemplate('order'); ?>
            </div>

            <div class="order-details__section mb-5">
                <ul class="nav nav-tabs-basic mb-4" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="items-tab" data-bs-toggle="tab" data-bs-target="#items" type="button" role="tab" aria-controls="item" aria-selected="true">
                            <?php echo vmText::_('COM_VIRTUEMART_ORDER_ITEM'); ?>
                        </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="history-tab" data-bs-toggle="tab" data-bs-target="#history" type="button" role="tab" aria-controls="history" aria-selected="false">
                            <?php echo vmText::_('COM_VIRTUEMART_ORDER_HISTORY'); ?>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="items" role="tabpanel" aria-labelledby="items-tab">
                        <?php echo $this->loadTemplate('items'); ?>
                    </div>
                    <div role="tabpanel" class="tab-pane " id="history" role="tabpanel" aria-labelledby="history-tab">
                        <?php echo $this->loadTemplate('history'); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>