<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$url = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $this->manufacturer->virtuemart_manufacturer_id);
?>
<div class="manufacturer-details-view">
    <div class="manufactuer-details-cont mb-5">
        <div class="row">
            <?php if (!empty($this->manufacturerImage)) : ?>
                <div class="col-md-6">
                    <div class="manufacturer-image-cont mb-3">
                        <?php echo $this->manufacturerImage; ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="<?php echo !empty($this->manufacturerImage) ? 'col-md-6' : 'col-12'; ?>">
                <h1><?php echo $this->manufacturer->mf_name; ?></h1>
                <?php if (!empty($this->manufacturer->mf_email)) : ?>
                    <div class="manufacturer-email-cont mb-3">
                        <?php echo HTMLHelper::_('email.cloak', $this->manufacturer->mf_email, true, $this->manufacturer->mf_email, false); ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($this->manufacturer->mf_url)) : ?>
                    <div class="manufacturer-url mb-3">
                        <a target="_blank" href="<?php echo $this->manufacturer->mf_url ?>"><?php echo $this->manufacturer->mf_url ?></a>
                    </div>
                <?php endif; ?>
                <?php if (!empty($this->manufacturer->mf_desc)) : ?>
                    <div class="manufacturer-description-cont mb-3">
                        <?php echo $this->manufacturer->mf_desc ?>
                    </div>
                <?php endif; ?>
                <div class="manufacturer-product-link">
                    <a target="_top" href="<?php echo $url; ?>" class="btn btn-primary"><?php echo vmText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $this->manufacturer->mf_name); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>