<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$template    = $app->getTemplate(true);
$params      = $template->params;
$cellWidth   = [];
$itemsPerRow = VmConfig::get('manufacturer_per_row', 3);
$perRowLg    = $params->get('items_per_row_lg', '');
$itemsPerRow = $perRowLg ? $perRowLg : $itemsPerRow;
$cellWidth[] = 'col-lg-' . floor(12 / $itemsPerRow);
$perRowMd    = $params->get('items_per_row_md', 3);
$cellWidth[] = 'col-md-' . floor(12 / $perRowMd);
$perRowSm    = $params->get('items_per_row_sm', 2);
$cellWidth[] = 'col-sm-' . floor(12 / $perRowSm);
$perRowXs    = $params->get('items_per_row_xs', 2);
$cellWidth[] = 'col-' . floor(12 / $perRowXs);
$cellWidth   = implode(' ', array_reverse($cellWidth));
$lazyLoad    = $params->get('vm_image_lazyload', 1);
$imageClass  = $lazyLoad ? 'manufacturer-image lazy' : 'manufacturer-image';
?>
<?php if (!empty($this->manufacturers)) : ?>
    <div class="manufacturer-view-default mb-4">
        <div class="row">
            <?php foreach ($this->manufacturers as $manufacturer) : ?>
                <?php $url = Route::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id); ?>
                <?php if ($params->get('manufacturer_link_to', 'products') === 'products') : ?>
                    <?php $url = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id); ?>
                <?php endif; ?>
                <div class="manufacturer d-flex <?php echo $cellWidth; ?>">
                    <div class="item-container add-hover-effect w-100 d-flex flex-column mb-4">
                        <div class="manufacturer-image d-flex align-items-center justify-content-center mb-3">
                            <a href="<?php echo $url; ?>">
                                <?php echo VirtuemartHelper::prepareLazyImageHTML($manufacturer->images[0]->displayMediaThumb('class="' . $imageClass . '"', false), $lazyLoad); ?>
                            </a>
                        </div>
                        <h3 class="manufacturer-name text-center m-0 mb-3">
                            <a href="<?php echo $url; ?>"><?php echo vmText::_($manufacturer->mf_name); ?></a>
                        </h3>
                        <div class="item-backdrop" aria-hidden="true" tabindex="-1"></div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>
