<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$category_id = vRequest::getInt('virtuemart_category_id', 0);
?>
<?php if ($this->showsearch || $this->keyword !== false) : ?>
    <div class="vm-list-search">
        <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=category&limitstart=0'); ?>" method="get">
            <?php if (!empty($this->searchCustomList)) : ?>
                <div class="vm-search-custom-list">
                    <?php echo $this->searchCustomList; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($this->searchCustomValuesAr)) : ?>
                <div class="vm-search-custom-values">
                    <?php echo shopFunctionsF::renderVmSubLayoutAsGrid(
                        'searchcustomvalues',
                        [
                                                'searchcustomvalues' => $this->searchCustomValuesAr,
                                                'options' => [
                                                    'items_per_row' => [
                                                        'xs' => 2,
                                                        'sm' => 2,
                                                        'md' => 2,
                                                        'lg' => 2,
                                                        'xl' => 2,
                                                    ],
                                                ],
                                            ]
                    ); ?>
                </div>
                <?php if (count($this->searchCustomValuesAr) > 1) : ?>
                    <div class="mb-3">
                        <label for="combineTags"><?php echo vmText::_('COM_VM_COMBINETAGS'); ?></label>
                        <?php echo VmHtml::checkbox('combineTags', $this->combineTags, 1, 0, '', 'combineTags'); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <div class="vm-search-custom-search-input mb-3">
                <div class="input-group">
                    <input name="keyword" class="form-control" type="text" size="40" value="<?php echo $this->keyword; ?>"/>
                    <input type="submit" value="<?php echo vmText::_('COM_VIRTUEMART_SEARCH') ?>" class="btn btn-primary"/>
                </div>
                <span class="vm-search-descr text-muted"> <?php echo vmText::_('COM_VM_SEARCH_DESC') ?></span>
            </div>

            <input type="hidden" name="view" value="category"/>
            <input type="hidden" name="option" value="com_virtuemart"/>
            <input type="hidden" name="virtuemart_category_id" value="<?php echo $category_id; ?>"/>
            <input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>"/>
        </form>
    </div>
<?php endif; ?>
