<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app            = Factory::getApplication();
$template       = $app->getTemplate(true);
$params         = $template->params;
$manufacturerId = $app->input->getInt('virtuemart_manufacturer_id', 0);
$hasProducts    = false;

if (!empty($this->products) && $this->fallback) {
    $products          = $this->products;
    $this->products    = [];
    $this->products[0] = $products;

    vmdebug('Refallback');
}

foreach ($this->products as $products) {
    if (!empty($products)) {
        $hasProducts = true;
        break;
    }
}

if (vRequest::getInt('dynamic', 0) && vRequest::getInt('virtuemart_product_id', 0)) {
    if (!empty($this->products)) {
        echo shopFunctionsF::renderVmSubLayout($this->productsLayout, ['products' => $this->products, 'currency' => $this->currency, 'products_per_row' => $this->perRow,'showRating' => $this->showRating]);
    }

    return;
}
?>
<div class="category-view">
    <?php if ($this->show_store_desc && !empty($this->vendor->vendor_store_desc)) : ?>
        <div class="vendor-store-desc mb-5">
            <?php echo $this->vendor->vendor_store_desc; ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($this->showcategory_desc) && empty($this->keyword)) : ?>
        <?php if (!empty($this->category) && !empty($this->category->category_description)) : ?>
            <div class="category_description mb-5">
                <?php echo $this->category->category_description; ?>
            </div>
        <?php endif; ?>
        <?php if (!empty($this->manu_descr)) : ?>
            <div class="manufacturer-description mb-5">
                <?php echo $this->manu_descr; ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if ($this->showcategory && empty($this->keyword) && !empty($this->category->has_children) && empty($manufacturerId)) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout('categories', ['categories' => $this->category->children, 'categories_per_row' => $this->categories_per_row]); ?>
    <?php endif; ?>

    <?php if (!empty($this->products) || ($this->showsearch || $this->keyword !== false)) : ?>
        <div class="browse-view">
            <?php if (!empty($this->category->category_name)) : ?>
                <div class="page-header">
                    <h1><?php echo vmText::_($this->category->category_name); ?></h1>
                </div>
            <?php endif; ?>

            <?php echo $this->loadTemplate('search'); ?>

            <?php if (!empty($this->orderByList) && $hasProducts) : ?>
                <div class="top-toolbar row align-items-center mb-5">
                    <div class="productlist-results col-auto d-none d-sm-block">
                        <?php echo $this->vmPagination->getResultsCounter(); ?>
                    </div>
                    <?php if (!empty($this->orderByList['orderby'])) : ?>
                        <div class="col-auto toolbar-seprator"></div>
                        <div class="orderby-container col-auto">
                            <?php echo $this->orderByList['orderby']; ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($this->orderByList['manufacturer'])) : ?>
                        <div class="col-auto toolbar-seprator d-none d-sm-block"></div>
                        <div class="manufacturer-filter-container col-auto d-none d-md-block">
                            <?php echo $this->orderByList['manufacturer']; ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($params->get('products_show_viewmode')) : ?>
                        <div class="productlist-viewmodes ms-auto col-auto">
                            <?php echo shopFunctionsF::renderVmSubLayout('viewmodes'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($this->products) && $hasProducts) : ?>
                <div class="product-items-container mb-5">
                    <?php echo shopFunctionsF::renderVmSubLayout($this->productsLayout, ['products' => $this->products, 'currency' => $this->currency, 'products_per_row' => $this->perRow, 'showRating' => $this->showRating]); ?>
                </div>

                <?php if (!empty($this->orderByList)) : ?>
                    <div class="vm-pagination d-flex flex-column flex-sm-row align-items-center mb-4 justify-content-between">
                        <div class="display-counter text-muted mb-3 mb-sm-0">
                            <?php echo $this->vmPagination->getPagesCounter(); ?>
                        </div>
                        <div class="mb-3 mb-sm-0 me-sm-0">
                            <?php echo $this->vmPagination->getPagesLinks(); ?>
                        </div>
                        <div class="display-limitbox normal-choice-wrapper d-flex justify-content-end">
                            <?php echo $this->vmPagination->getLimitBox($this->category->limit_list_step); ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php elseif ($this->keyword !== false) : ?>
                <div class="empty-card">
                    <div class="empty-card-icon" aria-hidden="true" tabindex="-1">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <div class="empty-card-heading">
                        <?php echo vmText::_('COM_VIRTUEMART_NO_RESULT') . ($this->keyword ? ' : (' . $this->keyword . ')' : ''); ?>
                    </div>
                </div>
            <?php elseif (empty($this->category->haschildren) || !empty($manufacturerId)) : ?>
                <div class="empty-card">
                    <div class="empty-card-icon" aria-hidden="true" tabindex="-1">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <div class="empty-card-heading">
                        <?php echo vmText::_('COM_VIRTUEMART_NO_RESULT'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php elseif (empty($this->category->haschildren) || !empty($manufacturerId)) : ?>
        <div class="empty-card">
            <div class="empty-card-icon" aria-hidden="true" tabindex="-1">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="empty-card-heading">
                <?php echo vmText::_('COM_VIRTUEMART_NO_RESULT'); ?>
            </div>
        </div>
    <?php endif; ?>
</div>
