<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$dataDynamicUpdate = VmConfig::get('oncheckout_ajax', false) ? ' data-dynamic-update="1"' : '';
?>
<?php if ($this->layoutName == $this->cart->layout) : ?>
    <?php if ($this->cart->virtuemart_paymentmethod_id) : ?>
        <h6 class="mb-2"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECTED_PAYMENT_SELECT'); ?></h6>
    <?php else : ?>
        <h6 class="mb-2"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECT_PAYMENT'); ?></h6>
    <?php endif; ?>
    <?php if ($this->found_payment_method) : ?>
        <div class="payment-methods">
            <?php foreach ($this->paymentplugins_payments as $payment_rates) : ?>
                <?php if (is_array($payment_rates)) : ?>
                    <?php foreach ($payment_rates as $payment_rate) : ?>
                        <div class="form-check form-check-vm">
                            <?php echo $payment_rate; ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php if (VmConfig::get('cart_extraSafeBtn', false)) : ?>
            <button type="submit" name="updatecart" class="btn btn-primary mt-3"<?php echo $dataDynamicUpdate; ?>>
                <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
            </button>
        <?php endif; ?>
    <?php else : ?>
        <div class="text-danger">
            <?php echo $this->payment_not_found_text; ?>
        </div>
    <?php endif; ?>
<?php else : ?>
    <?php if (VmConfig::get('oncheckout_show_steps', 1)) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout('checkoutsteps', ['activeStep' => 4]); ?>
    <?php endif; ?>
    <h3 class="mb-4"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECT_PAYMENT'); ?></h3>
    <form id="paymentForm" name="choosePaymentRate" action="<?php echo Route::_('index.php'); ?>" method="post">
        <?php if ($this->found_payment_method) : ?>
            <div class="mb-4">
                <?php foreach ($this->paymentplugins_payments as $payment_rates) : ?>
                    <?php if (is_array($payment_rates)) : ?>
                        <?php foreach ($payment_rates as $payment_rate) : ?>
                            <div class="form-check form-check-vm">
                                <?php echo $payment_rate; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
            <button type="submit" name="updatecart" class="btn btn-primary me-2">
                <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
            </button>
            <button type="reset" class="btn btn-secondary"  onClick="window.location.href='<?php echo Route::_('index.php?option=com_virtuemart&view=cart&task=cancel'); ?>'">
                <?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?>
            </button>
        <?php else : ?>
            <div class="text-danger">
                <?php echo $this->payment_not_found_text; ?>
            </div>
        <?php endif; ?>
        <input type="hidden" name="option" value="com_virtuemart" />
        <input type="hidden" name="view" value="cart" />
        <input type="hidden" name="task" value="updatecart" />
        <input type="hidden" name="controller" value="cart" />
        <?php if (method_exists(vRequest::class, 'getFormToken')) : ?>
            <input type="hidden" name="<?php echo vRequest::getFormToken(); ?>" value="1" />
        <?php endif; ?>
    </form>
<?php endif; ?>
