<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

$messageQueue = Factory::getApplication()->getMessageQueue();
?>
<div class="cart-popup">
    <div class="cart-popup-content">
        <?php foreach ($messageQueue as $message) : ?>
            <p class="text-danger text-center"><?php echo $message['message']; ?></p>
        <?php endforeach; ?>

        <?php if (!empty($this->product_name)) : ?>
            <p class="text-bold text-center"><?php echo $this->product_name; ?></p>
        <?php endif; ?>
    </div>

    <div class="cart-popup-buttons">
        <a href="<?php echo $this->continue_link; ?>" class="btn btn-secondary continue-link"><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?></a>
    </div>
</div>
