<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app      = Factory::getApplication();
$template = $app->getTemplate(true);
?>
<div class="cart-popup">
    <div class="cart-popup-content">
        <?php if ($this->products && is_array($this->products) && count($this->products) > 0) : ?>
            <div class="cart-popup-message">
                <?php foreach ($this->products as $product) : ?>
                    <?php if ($product->quantity > 0) : ?>
                        <?php $quantity = isset($product->quantityAdded) ? $product->quantityAdded : $product->quantity; ?>
                        <p class="text-center">
                            <?php echo vmText::sprintf('COM_VIRTUEMART_CART_PRODUCT_ADDED', $product->product_name, $quantity); ?>
                        </p>
                    <?php endif; ?>
                    <?php if (!empty($product->errorMsg)) : ?>
                        <p class="text-center text-danger">
                            <?php echo $product->errorMsg; ?>
                        </p>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php if (VmConfig::get('popup_rel', 1)) : ?>
            <?php if ($this->products && is_array($this->products) && count($this->products) > 0) : ?>
                <?php
                $displayed             = 0;
                $maximumAllowedItems   = $template->params->get('maximum_ajax_related_products', 4);
                $product               = reset($this->products);
                $customFieldsModel     = VmModel::getModel('customfields');
                $product->customfields = $customFieldsModel->getCustomEmbeddedProductCustomFields($product->allIds, 'R');
                $customFieldsModel->displayProductCustomfieldFE($product, $product->customfields);
                ?>
                <?php if (!empty($product->customfields)) : ?>
                    <div class="cart-popup-related-products pt-4">
                        <h4 class="text-center text-uppercase mb-4">
                            <?php echo vmText::_('COM_VIRTUEMART_RELATED_PRODUCTS_HEADING'); ?>
                        </h4>
                        <div class="row">
                            <?php foreach ($product->customfields as $rFields) : ?>
                                <?php if (!empty($rFields->display) && $displayed < $maximumAllowedItems) : ?>
                                    <div class="col-6 col-sm-4 col-md-3">
                                        <div class="product-field-display mb-4">
                                            <?php echo $rFields->display; ?>
                                        </div>
                                    </div>
                                    <?php $displayed++; ?>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <div class="cart-popup-buttons">
        <a href="<?php echo $this->continue_link; ?>" class="btn btn-secondary continue-link"><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?></a>
        <a href="<?php echo $this->cart_link; ?>" class="btn btn-primary cart-link"><?php echo vmText::_('COM_VIRTUEMART_CART_SHOW'); ?></a>
    </div>
</div>
