<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$app         = Factory::getApplication();
$search      = $app->input->get('usersearch', '', 'STRING');
$currentUser = $this->cart->user->virtuemart_user_id;
$tempGroup   = Factory::getSession()->get('tempShopperGroups', false, 'vm');

vmJsApi::chosenDropDowns();
?>
<div class="cart-shopper-form mb-4">
    <div class="row">
        <div class="col-md-6">
            <div class="border p-4 h-100">
                <h5 class="fs-5 mb-4">
                    <?php echo vmText::_('COM_VIRTUEMART_CART_CHANGE_SHOPPER'); ?>
                </h5>
                <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=cart'); ?>" method="post">
                    <div class="control-group">
                        <div class="input-group">
                            <input type="search" name="usersearch" class="form-control" value="<?php echo $search; ?>" />
                            <button type="submit" name="searchShopper" class="btn btn-secondary">
                                <?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>
                            </button>
                            <?php if (!empty($search)) : ?>
                                <button type="button" name="searchShopper" class="btn btn-secondary" onclick="this.form.usersearch.value = ''; this.form.submit();">
                                    <?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="control-group">
                        <?php echo HTMLHelper::_('select.genericlist', $this->userList, 'userID', ['class' => 'form-select vm-chzn-select'], 'id', 'displayedName', $currentUser, 'userIDcart'); ?>
                    </div>
                    <div class="mb-2">
                        <button type="submit" name="changeShopper" class="btn btn-primary w-100">
                            <?php echo vmText::_('COM_VIRTUEMART_GO'); ?>
                        </button>
                    </div>
                    <input type="hidden" name="view" value="cart"/>
                    <input type="hidden" name="task" value="changeShopper"/>
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
            </div>
        </div>
        <div class="col-md-6">
        <div class="border p-4 h-100">
                <h5 class="fs-5 mb-4">
                    <?php echo vmText::_('COM_VIRTUEMART_CART_CHANGE_SHOPPERGROUP'); ?>
                </h5>
                <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=cart'); ?>" method="post">
                    <div class="control-group">
                        <?php if ($this->shopperGroupList) : ?>
                            <?php echo $this->shopperGroupList; ?>
                        <?php endif; ?>
                    </div>
                    <div class="mb-2">
                        <button type="submit" name="changeShopperGroup" class="btn btn-primary w-100">
                            <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
                        </button>
                    </div>
                    <?php if (!empty($tempGroup)) : ?>
                        <button type="button" name="changeShopperGroup" class="btn btn-secondary w-100" onclick="window.location.href='<?php echo Route::_('index.php?option=com_virtuemart&view=cart&task=resetShopperGroup'); ?>';">
                            <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
                        </button>
                    <?php endif; ?>
                    <input type="hidden" name="view" value="cart"/>
                    <input type="hidden" name="task" value="changeShopperGroup"/>
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
            </div>
        </div>
    </div>
</div>