<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;
?>
<?php if ($this->layoutName == $this->cart->layout) : ?>
    <div class="input-group cart-coupon-field">
        <input type="text" name="coupon_code" class="form-control" placeholder="<?php echo $this->coupon_text; ?>" />
        <button type="submit" name="setcoupon" class="btn btn-primary">
            <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
        </button>
    </div>
<?php else : ?>
    <form name="enterCouponCode" action="<?php echo Route::_('index.php'); ?>" method="post">
        <div class="input-group">
            <input type="text" name="coupon_code" class="form-control" placeholder="<?php echo $this->coupon_text; ?>" />
            <button type="submit" name="setcoupon" class="btn btn-primary">
                <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
            </button>
        </div>
        <input type="hidden" name="option" value="com_virtuemart" />
        <input type="hidden" name="view" value="cart" />
        <input type="hidden" name="task" value="setcoupon" />
        <input type="hidden" name="controller" value="cart" />
    </form>
<?php endif; ?>