<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$closeFieldset = false;
$hiddenFields  = [];
$position      = 0
?>
<?php if (!empty($this->userFieldsCart['fields'])) : ?>
    <div class="cart-fields-section old-form">
        <?php foreach ($this->userFieldsCart['fields'] as $field) : ?>
            <?php if ($field['type'] === 'delimiter') : ?>
                <?php if ($closeFieldset) : ?>
                    <?php echo '</fieldset>' . "\n"; ?>
                <?php endif; ?>

                <?php if ($field['name'] === 'delimiter_userinfo') : ?>
                    <?php if ($this->getLayout() === 'edit') : ?>
                        <?php echo $this->loadTemplate('vmshopper'); ?>
                    <?php endif; ?>
                <?php else : ?>
                    <?php echo '<fieldset>' . "\n"; ?>
                    <?php echo '<legend>' . $field['title'] . '</legend>' . "\n"; ?>
                    <?php $closeFieldset = true; ?>
                <?php endif; ?>
            <?php elseif ($field['hidden']) : ?>
                <?php $hiddenFields[] = $field['formcode']; ?>
            <?php else : ?>
                <?php if ($position === 0) : ?>
                    <?php echo '<fieldset>' . "\n"; ?>
                    <?php $closeFieldset = true; ?>
                <?php endif; ?>

                <?php $title = empty($field['description']) ? $field['title'] : strip_tags($field['description']); ?>
                <div class="control-group">
                    <?php if ($field['name'] != 'tos') : ?>
                        <div class="control-label">
                            <label class="form-label <?php echo $field['name']; ?>-label" for="<?php echo $field['name']; ?>_field">
                                <span class="has-tooltip" title="<?php echo $title; ?>">
                                    <?php echo $field['title'] . ($field['required'] ? ' <span class="asterisk" aria-hidden="true">*</span>' : ''); ?>
                                </span>
                            </label>
                        </div>
                    <?php endif; ?>
                    <div class="controls">
                        <?php echo $field['formcode']; ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php $position++; ?>
        <?php endforeach; ?>

        <?php if ($closeFieldset) : ?>
            <?php echo '</fieldset>' . "\n"; ?>
        <?php endif; ?>

        <?php !empty($hiddenFields) ? implode("\n", $hiddenFields) : ''; ?>
    </div>
<?php endif; ?>