<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$cartfieldNames = [];

foreach ($this->userFieldsCart['fields'] as $fields) {
    $cartfieldNames[] = $fields['name'];
}

$this->cart->lists['current_id'] = !isset($this->cart->lists['current_id']) ? 0 : $this->cart->lists['current_id'];
$this->cart->selected_shipto     = !isset($this->cart->selected_shipto) ? 0 : $this->cart->selected_shipto;
?>
<div class="cart-addresses">
    <div class="billing-address-section mb-4">
        <h6><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_LBL'); ?></h6>
        <div class="billing-address mb-3">
            <?php foreach ($this->cart->BTaddress['fields'] as $field) : ?>
                <?php if ($field['name'] === 'agreed') : ?>
                    <?php $field['value'] = $field['value'] === 0 ? vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_NO') : vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_YES'); ?>
                <?php endif; ?>

                <?php if (in_array($field['name'], $cartfieldNames) || empty($field['value'])) : ?>
                    <?php continue; ?>
                <?php endif; ?>

                <span class="values field-<?php echo $field['name'] ?>"><?php echo $field['value'] ?></span>
                <?php if ($field['name'] != 'title' && $field['name'] != 'first_name' && $field['name'] != 'middle_name' && $field['name'] != 'zip') : ?>
                    <div class="clearfix" aria-hidden="true" tabindex="-1"></div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=BT', $this->useXHTML, $this->useSSL) ?>" class="btn btn-secondary btn-sm w-100" rel="nofollow">
            <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EDIT_BILLTO_LBL'); ?>
        </a>
        <input type="hidden" name="billto" value="<?php echo $this->cart->lists['billTo']; ?>" />
    </div>
    <div class="shipping-address-section mb-4">
        <h6><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_SHIPTO_LBL'); ?></h6>
        <div class="shipping-address mb-3">
            <?php if (empty($this->cart->user->virtuemart_user_id)) : ?>
                <div class="form-check form-check-vm">
                    <?php echo VmHtml::checkbox('STsameAsBT', $this->cart->STsameAsBT, 1, 0, 'id="STsameAsBTjs" data-dynamic-update=1'); ?>
                    <label for="STsameAsBTjs">
                        <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_ST_SAME_AS_BT'); ?>
                    </label>
                </div>
            <?php else : ?>
                <div class="mb-2">
                    <?php echo $this->cart->lists['shipTo']; ?>
                </div>
            <?php endif; ?>
            <?php if (empty($this->cart->STsameAsBT) && !empty($this->cart->ST) && !empty($this->cart->STaddress['fields'])) : ?>
                <div id="output-shipto-display">
                    <?php foreach ($this->cart->STaddress['fields'] as $field) : ?>
                        <?php if ($field['name'] === 'agreed') : ?>
                            <?php $field['value'] = $field['value'] === 0 ? vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_NO') : vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_YES'); ?>
                        <?php endif; ?>

                        <?php if (in_array($field['name'], $cartfieldNames) || empty($field['value']) || $field['name'] == 'shipto_address_type_name') : ?>
                            <?php continue; ?>
                        <?php endif; ?>

                        <span class="values field-<?php echo $field['name'] ?>"><?php echo $field['value'] ?></span>
                        <?php if ($field['name'] != 'shipto_title' && $field['name'] != 'shipto_first_name' && $field['name'] != 'shipto_middle_name' && $field['name'] != 'shipto_zip') : ?>
                            <div class="clearfix" aria-hidden="true" tabindex="-1"></div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=ST&virtuemart_user_id[]=' . $this->cart->lists['current_id'] . '&virtuemart_userinfo_id=' . $this->cart->selected_shipto, $this->useXHTML, $this->useSSL) ?>" class="btn btn-secondary  btn-sm w-100" rel="nofollow">
            <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EDIT_SHIPTO_LBL'); ?>
        </a>
        <input type="hidden" name="billto" value="<?php echo $this->cart->lists['billTo']; ?>" />
    </div>
</div>
