<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;

defined('_JEXEC') or die;

$user      = Factory::getApplication()->getIdentity();
$returnUrl = TemplateHelper::getReturnUrl();
$formToken = Session::getFormToken();
$logoutUrl = Route::_('index.php?option=com_users&task=user.logout&' . $formToken . '=1&return=' . base64_encode($returnUrl));

if ($this->cart->getDataValidated()) {
    if ($this->cart->_inConfirm) {
        $buttonText = vmText::_('COM_VIRTUEMART_CANCEL_CONFIRM');
    } else {
        $buttonText = vmText::_('COM_VIRTUEMART_ORDER_CONFIRM_MNU');
    }
} else {
    $buttonText = vmText::_('COM_VIRTUEMART_CHECKOUT_TITLE');
}

vmJsApi::vmValidator();
?>
<div class="payments-signin-button" aria-hidden="true"></div>

<div id="cart-view" class="cart-view">
    <?php if (empty($this->cart->totalProduct)) : ?>
        <div class="cart-is-empty-section d-flex flex-column justify-content-center align-items-center text-center">
            <div class="empty-cart-icon text-center" aria-hidden="true" tabindex="-1">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <p class="empty-cart-heading text-center">
                <?php echo Text::_('TPL_VP_NEOTERIC_EMPTY_CART_HEADING'); ?>
            </p>
            <p class="empty-cart-subheading text-center">
                <?php echo Text::_('TPL_VP_NEOTERIC_EMPTY_CART_SUBHEADING'); ?>
            </p>
            <a class="btn btn-primary btn-lg" href="<?php echo $this->continue_link; ?>">
                <?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?>
            </a>
        </div>
    <?php else : ?>
        <div class="page-header">
            <h1 class="d-flex gap-3">
                <span class="cart-title"><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?></span>
                <?php if (!empty($this->cart->totalProduct)) : ?>
                    <span class="cart-item-count text-muted">(<?php echo Text::plural('TPL_VP_NEOTERIC_ITEM_COUNT_N', $this->cart->totalProduct); ?>)</span>
                <?php endif; ?>
            </h1>
        </div>

        <?php if (VmConfig::get('oncheckout_show_steps', 1)) : ?>
            <?php if ($this->checkout_task == 'checkout') : ?>
                <?php echo shopFunctionsF::renderVmSubLayout('checkoutsteps', ['activeStep' => 2]); ?>
            <?php else : ?>
                <?php echo shopFunctionsF::renderVmSubLayout('checkoutsteps', ['activeStep' => 5]); ?>
            <?php endif; ?>
        <?php endif; ?>
        
        <?php if ($this->allowChangeShopper && !$this->isPdf) : ?>
            <?php echo $this->loadTemplate('shopperform'); ?>
        <?php endif; ?>

        <form method="post" id="checkoutForm" name="checkoutForm" action="<?php echo Route::_('index.php?option=com_virtuemart&view=cart', $this->useXHTML, $this->useSSL); ?>" novalidate="novalidate">
            <?php if (!$this->isPdf && VmConfig::get('multixcart') == 'byselection') : ?>
                <div class="vendor-selection-section mb-4">
                    <div class="row g-3">
                        <div class="col-10">
                            <?php echo shopFunctions::renderVendorFullVendorList($this->cart->vendorId); ?>
                        </div>
                        <div class="col-2">
                            <button type="submit" name="updatecart" class="btn btn-secondary">
                                <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
                
            <div class="row">
                <div class="col-lg-8">
                    <?php echo $this->loadTemplate('pricelist'); ?>

                    <?php if (!empty($this->checkoutAdvertise)) : ?>
                        <div id="checkout-advertise-box">
                            <?php foreach ($this->checkoutAdvertise as $checkoutAdvertise) : ?>
                                <div class="checkout-advertise mb-3">
                                    <?php echo $checkoutAdvertise; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-4">
                    <div class="cart-summery border border-3 p-3 p-md-4 p-lg-5">
                        <h3 class="text-uppercase mb-3 mb-md-4">
                            <?php echo vmText::_('TPL_VP_NEOTERIC_TITLE_ORDER'); ?>
                        </h3>
                        
                        <?php if (empty($this->cart->user->virtuemart_user_id)) : ?>
                            <div class="cart-login-section mb-4">
                                <?php GlobalHelper::getInstance()->setData('showOffcanvasLogin', true); ?>
                                <p>
                                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?><br/>
                                    <a class="btn btn-secondary btn-sm w-100 mt-3" href="#" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLogin" aria-controls="offcanvasLogin">
                                        <?php echo vmText::_('JLOGIN'); ?>
                                    </a>
                                </p>
                            </div>
                        <?php else : ?>
                            <div class="cart-login-section mb-4">
                                <div class="d-flex align-items-center">
                                    <div class="login-greeting me-2"><?php echo vmText::sprintf('COM_VIRTUEMART_HINAME', $user->name); ?></div>
                                    <a href="#" onclick="window.location.href = '<?php echo $logoutUrl; ?>'; return false;">
                                        <?php echo vmText::_('JLOGOUT'); ?>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php echo $this->loadTemplate('address'); ?>

                        <?php echo $this->loadTemplate('cartfields'); ?>

                        <div class="separator-line mb-4" aria-hidden="true" tabindex="-1"></div>
                        
                        <?php if (!empty($this->cart->cartPrices['billTotal'])) : ?>
                            <div class="cart-order-total d-flex justify-content-between align-items-center fw-bold fs-5 mb-4">
                                <?php echo vmText::_('COM_VIRTUEMART_CART_TOTAL'); ?>
                                <?php echo $this->currencyDisplay->createPriceDiv('billTotal', '', $this->cart->cartPrices['billTotal'], false); ?>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($this->totalInPaymentCurrency)) : ?>
                            <div class="cart-order-payment-total d-flex justify-content-between align-items-center fw-bold fs-5 mb-4">
                                <?php echo vmText::_('COM_VIRTUEMART_CART_TOTAL_PAYMENT'); ?>
                                <div class="totalInPaymentCurrency">
                                    <?php echo $this->totalInPaymentCurrency; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="submit-button-container pt-2">
                            <button type="submit" id="checkoutFormSubmit" name="<?php echo $this->checkout_task; ?>" value="1" class="btn btn-primary btn-lg w-100">
                                <span><?php echo $buttonText; ?></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <input type="hidden" name="virtuemart_vendor_id" value="<?php echo $this->cart->vendorId; ?>" />
            <input type="hidden" name="order_language" value="<?php echo $this->order_language; ?>" />
            <input type="hidden" name="task" value="updatecart" />
            <input type="hidden" name="option" value="com_virtuemart" />
            <input type="hidden" name="view" value="cart" />
            <?php if (method_exists(vRequest::class, 'getFormToken')) : ?>
                <input type="hidden" name="<?php echo vRequest::getFormToken(); ?>" value="1" />
            <?php endif; ?>
        </form>

        <div class="continue-shopping-section my-3">
            <a class="py-2 d-inline-block" href="<?php echo $this->continue_link; ?>">
                <i class="vpi vpi-long-arrow-alt-left" aria-hidden="true"></i>&nbsp;&nbsp;<?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?>
            </a>
        </div>
    <?php endif; ?>
<?php
vmJsApi::addJScript('vm-checkoutFormSubmit', <<<EOT
var Virtuemart = window.Virtuemart || {};

(function($) {
    Virtuemart.bCheckoutButton = function(e) {
        e.preventDefault();

        $(this).vm2front('startVmLoading');
        $(this).attr('disabled', true);

        var name = $(this).attr('name');
        var hiddenInput = $('<input />');

        hiddenInput.attr('type', 'hidden');
        hiddenInput.attr('name', name);
        hiddenInput.val('1');

        $('#checkoutForm').append(hiddenInput);

        if (name === 'confirm') {
            $('#checkoutForm').attr('action', '{$this->orderDoneLink}');
        }

        $('#checkoutForm').submit();
    }

    Virtuemart.bindClickCheckoutButton = function() {
        $(this).vm2front('stopVmLoading');

        $('#checkoutFormSubmit').off('click').off('dblclick').on('click dblclick', Virtuemart.bCheckoutButton);
    }

    $(function() {
        Virtuemart.bindClickCheckoutButton();
    });
})(jQuery);
EOT);

$ajaxOpcScript = <<<EOT
(function($) {
    var onClickSTsameAsBT = function() {
        var input = $('#STsameAsBT');
        var output = $('#output-shipto-display');

        if($(this).is(':checked')){
            input.val('1') ;
            output.addClass('d-none');
        } else {
            input.val('0') ;
            output.removeClass('d-none');
        }

        $('#checkoutFormSubmit').click();
    }

    var bindSTsameAsBT = function() {
        var checkBox = $('#STsameAsBTjs');
        var output = $('#output-shipto-display');

        if (checkBox.is(':checked')) {
            output.addClass('d-none');
        } else {
            output.removeClass('d-none');
        }

        checkBox.off('change', onClickSTsameAsBT);
        checkBox.on('change', onClickSTsameAsBT);
    }

    $(function() {
        bindSTsameAsBT();
    })
})(jQuery);
EOT;

if (!VmConfig::get('oncheckout_ajax', false)) {
    vmJsApi::addJScript('vm-STisBT', $ajaxOpcScript);
}

$this->addCheckRequiredJs();
vmJsApi::addJScript('vmprices', false, false);
echo vmJsApi::writeJS();
?>
</div>
