<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 **/

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$vendorModel = VmModel::getModel('vendor');
$template    = $app->getTemplate(true);
$params      = $template->params;
$vendor      = $vendorModel->getVendor($this->product->virtuemart_vendor_id);
$minLength   = VmConfig::get('asks_minimum_comment_length', 50);
$maxLength   = VmConfig::get('asks_maximum_comment_length', 2000);
$session     = $app->getSession();
$sessionData = $session->get('askquestion', 0, 'vm');
$name        = isset($sessionData['name']) ? $sessionData['name'] : '';
$email       = isset($sessionData['email']) ? $sessionData['email'] : '';
$comment     = isset($sessionData['comment']) ? $sessionData['comment'] : '';

if (!empty($this->user->name)) {
    $name = $this->user->name;
}

if (!empty($this->user->email)) {
    $email = $this->user->email;
}

vmJsApi::JvalideForm();

vmJsApi::addJScript('askform', '
jQuery(function($) {
    $("#askform").validationEngine("attach", {
        promptPosition: "topLeft"
    });

    $("#comment-text-counter").val($("#ask-comment").val().length);

    $("#ask-comment").keyup(function () {
        $("#comment-text-counter").val($(this).val().length);
    });
});
');
?>
<?php if (empty($this->product)) : ?>
    <div class="alert alert-warning">
        <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND'); ?>
        <?php if (!empty($this->continue_link_html)) : ?>
            <br /><br />
            <?php echo $this->continue_link_html; ?>
        <?php endif; ?>
    </div>
<?php else : ?>
    <?php if (!empty($this->login)) : ?>
        <?php echo $this->login; ?>
    <?php elseif (empty($this->login) || VmConfig::get('recommend_unauth', false)) : ?>
        <div class="ask-product">
            <h1 class="modal-page-title"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ASK_QUESTION'); ?></h1>
            <div class="card mb-3">
                <div class="row g-0">
                    <div class="col-md-3">
                        <?php echo $this->product->images[0]->displayMediaThumb(['class' => 'product-image img-fluid rounded-start object-fit-cover h-100 w-100'], false); ?>
                    </div>
                    <div class="col-md-9">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo $this->product->product_name; ?></h5>
                            <div class="card-text">
                                <?php if (!empty($this->product->product_s_desc)) : ?>
                                    <?php if ($this->product->product_s_desc != strip_tags($this->product->product_s_desc)) : ?>
                                        <div class="short-description mb-4">
                                            <?php echo $this->product->product_s_desc; ?>
                                        </div>
                                    <?php else : ?>
                                        <p class="short-description mb-4">
                                            <?php echo nl2br($this->product->product_s_desc); ?>
                                        </p>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if ($params->get('show_sku', 1) && !empty($this->product->product_sku)) : ?>
                                    <div class="product-sku mb-2">
                                        <span><?php echo vmText::_('COM_VIRTUEMART_CART_SKU'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_sku; ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php if ($params->get('show_mpn', 0) && !empty($this->product->product_mpn)) : ?>
                                    <div class="product-mpn mb-2">
                                        <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_MPN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_mpn; ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php if ($params->get('show_gtin', 1) && !empty($this->product->product_gtin)) : ?>
                                    <div class="product-gtin mb-2">
                                        <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_GTIN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_gtin; ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($this->product->virtuemart_category_id)) : ?>
                                    <div class="product-category mb-2">
                                        <span><?php echo vmText::_('COM_VIRTUEMART_CATEGORY_NAME'); ?>:</span>&nbsp;<a href="<?php echo Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $this->product->virtuemart_category_id); ?>" class="link-body-invert" target="_parent"><?php echo vmText::_($this->product->category_name); ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($params->get('show_social_share', 1)) : ?>
                                    <div class="social-share-icons">
                                        <?php echo shopFunctionsF::renderVmSubLayout('productshare', ['product' => $this->product]); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-container">
                <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component'); ?>" name="askform" id="askform" method="post" class="form-validate">
                    <div class="form-group position-relative mb-3">
                        <label for="ask-name" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_NAME'); ?></label>
                        <input type="text" class="form-control validate[required,minSize[3],maxSize[64]]" id="ask-name" value="<?php echo $this->escape($name); ?>" name="name" />
                    </div>
                    <div class="form-group position-relative mb-3">
                        <label for="ask-email" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EMAIL'); ?></label>
                        <input type="text" class="form-control validate[required,custom[email]]" id="ask-email" value="<?php echo $this->escape($email); ?>" name="email" />
                    </div>
                    <div class="form-group position-relative mb-1">
                        <label for="ask-comment" class="form-label"><?php echo vmText::sprintf('COM_VIRTUEMART_ASK_COMMENT', $minLength, $maxLength); ?></label>
                        <textarea class="form-control validate[required,minSize[<?php echo $minLength; ?>],maxSize[<?php echo $maxLength; ?>]]" id="ask-comment" name="comment" rows="5"><?php echo $this->escape($comment); ?></textarea>
                    </div>
                    <div class="form-group form-group-text-counter d-flex align-items-center">
                        <label for="comment-text-counter" class="text-muted me-1"><?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT'); ?></label>
                        <input type="text" value="0" class="form-control form-control-sm text-center" id="comment-text-counter" disabled />
                    </div>
                    <?php if (!empty($this->captcha)) : ?>
                        <div class="mb-3">
                            <?php echo $this->captcha; ?>
                        </div>
                    <?php endif; ?>
                    <div class="form-submit pt-2">
                        <button type="submit" class="btn btn-primary" name="submit_ask"><?php echo vmText::_('COM_VIRTUEMART_ASK_SUBMIT'); ?></button>
                    </div>

                    <input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>" />
                    <input type="hidden" name="tmpl" value="component" />
                    <input type="hidden" name="view" value="productdetails" />
                    <input type="hidden" name="option" value="com_virtuemart" />
                    <input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>" />
                    <input type="hidden" name="task" value="mailAskquestion" />
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>