<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Virtueplanet\Plugin\System\Prime\Helper\GoogleFontHelper;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;

/** @var Joomla\CMS\Document\ErrorDocument $this */

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app = Factory::getApplication();
$wa  = $this->getWebAssetManager();

/** @var Joomla\Registry\Registry $params */
$params = $this->params;

// Detecting Active Variables
$option    = strtolower($app->input->getCmd('option', ''));
$view      = strtolower($app->input->getCmd('view', ''));
$layout    = strtolower($app->input->getCmd('layout', ''));
$task      = strtolower($app->input->getCmd('task', ''));
$itemid    = $app->input->getInt('Itemid', 0);
$tmpl      = strtolower($app->input->getCmd('tmpl', ''));
$manage    = $app->input->getInt('manage', 0);
$sitename  = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu      = $app->getMenu()->getActive();
$pageclass = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';
$version   = TemplateHelper::getVersionFromManifest(__DIR__ . '/templateDetails.xml');
$template  = $app->getTemplate(false);
$bodyClass = ' error-code-' . $this->error->getCode() .
    ($this->debug ? ' debugging-enabled' : ' debugging-disabled') .
    ($option ? ' ' . str_replace('_', '-', $option) : '') .
    ($view ? ' view-' . $view : ' no-view') .
    ($layout ? ' layout-' . $layout : ' no-layout') .
    ($task ? ' task-' . $task : ' no-task') .
    ($itemid ? ' itemid-' . $itemid : '') .
    ($pageclass ? ' ' . $pageclass : '') .
    ($this->direction === 'rtl' ? ' rtl' : ' ltr') .
    (' tpl-' . str_replace('_', '-', $template)) .
    (' v-' . $version) .
    (' j-' . substr(JVERSION, 0, 1));

// Container class.
$containerClass = $params->get('fluid_container', 0) ? 'container-fluid' : 'container-xxl';

// Use a font scheme if set in the template style options
$paramsFontScheme = $params->get('use_font_scheme', 'media/templates/site/vp_neoteric/css/global/fonts-local_roboto.css');

if ($paramsFontScheme) {
    if ($paramsFontScheme === 'google') {
        $bodyFontName       = $params->get('google_font_name', '');
        $bodyFontVariant    = $params->get('google_font_variant', '');
        $addFontVariants    = $params->get('google_font_additional_variants', []);
        $headingFontName    = $params->get('heading_google_font_name', '');
        $headingFontVariant = $params->get('heading_google_font_variant', '');
        $gfontsJsonFile     = 'media/templates/site/vp_neoteric/webfonts/gfonts.json';
        $fontStyles         = '';

        if ($bodyFontName || $headingFontName) {
            $this->getPreloadManager()->preconnect('https://fonts.googleapis.com/', ['crossorigin' => 'anonymous']);
            $this->getPreloadManager()->preconnect('https://fonts.gstatic.com/', ['crossorigin' => 'anonymous']);

            if ($bodyFontName) {
                GoogleFontHelper::addFontFamily($bodyFontName, $bodyFontVariant);

                if (!empty($addFontVariants)) {
                    GoogleFontHelper::addFontFamily($bodyFontName, $addFontVariants);
                }

                $fontInfo = GoogleFontHelper::getFontInfo($bodyFontName, $bodyFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-body: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-normal: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-normal: ' . $fontInfo->style . ";\n";
                }
            }

            if ($headingFontName) {
                GoogleFontHelper::addFontFamily($headingFontName, $headingFontVariant);

                $fontInfo = GoogleFontHelper::getFontInfo($headingFontName, $headingFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-headings: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-headings: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-headings: ' . $fontInfo->style . ";\n";
                }
            }

            $fontStyleUrl = GoogleFontHelper::getAddedFontsUrl();

            if ($fontStyleUrl) {
                $this->getPreloadManager()->preload($fontStyleUrl, ['as' => 'style', 'crossorigin' => 'anonymous']);

                if ($params->get('lazyload_google_fonts', 1)) {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'print', 'rel' => 'lazy-stylesheet', 'onload' => 'this.media=\'all\'', 'crossorigin' => 'anonymous']);
                } else {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'all', 'crossorigin' => 'anonymous']);
                }
            }
        }

        if (!empty($fontStyles)) {
            $wa->addInlineStyle(":root {\n" . $fontStyles . "}");
        }
    } else {
        $wa->registerAndUseStyle('fontscheme.current', $paramsFontScheme, ['version' => 'auto'], ['media' => 'all']);
        $this->getPreloadManager()->preload($wa->getAsset('style', 'fontscheme.current')->getUri() . '?' . $this->getMediaVersion(), ['as' => 'style']);
    }
}

// Enable assets
$wa->usePreset('template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr'))
    ->useStyle('template.active.language')
    ->useStyle('template.user')
    ->useScript('template.user');

// Add CSS variables
$cssVariables    = TemplateHelper::getCSSVariables($params, __DIR__, 'style');
$cssVariablesStr = '';

foreach ($cssVariables as $name => $value) {
    $cssVariablesStr .= $name . ': ' . $value . ';' . "\n";
}

$cssVariablesStr = ':root {' . "\n" . $cssVariablesStr . '}';

$wa->addInlineStyle($cssVariablesStr);

// Override 'template.active' asset to set correct ltr/rtl dependency
$wa->registerStyle('template.active', '', [], [], ['template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr')]);

// Browsers support SVG favicons
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
$this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => '#000']);

// Logo file or site title param
if ($params->get('logo_file')) {
    $logo = HTMLHelper::_('image', Uri::root(false) . htmlspecialchars($this->params->get('logo_file'), ENT_QUOTES), $sitename, ['class' => 'logo d-inline-block', 'loading' => 'eager', 'decoding' => 'async'], false, 0);
} elseif ($params->get('site_title')) {
    $logo = '<span title="' . $sitename . '">' . htmlspecialchars($params->get('site_title'), ENT_COMPAT, 'UTF-8') . '</span>';
} else {
    $logo = HTMLHelper::_('image', 'logo.svg', $sitename, ['class' => 'logo d-inline-block', 'loading' => 'eager', 'decoding' => 'async'], true, 0);
}

// Small logo file or site title param
if ($params->get('logo_file_small')) {
    $smallLogo = HTMLHelper::_('image', Uri::root(false) . htmlspecialchars($this->params->get('logo_file_small'), ENT_QUOTES), $sitename, ['class' => 'logo d-inline-block', 'loading' => 'eager', 'decoding' => 'async'], false, 0);
} elseif ($params->get('logo_file')) {
    $smallLogo = '<img src="' . Uri::root(true) . '/' . htmlspecialchars($params->get('logo_file'), ENT_QUOTES) . '" alt="' . $sitename . '">';
} elseif ($params->get('site_title')) {
    $smallLogo = '<span title="' . $sitename . '">' . htmlspecialchars($params->get('site_title'), ENT_COMPAT, 'UTF-8') . '</span>';
} else {
    $smallLogo = HTMLHelper::_('image', 'logo.svg', $sitename, ['class' => 'logo d-inline-block', 'loading' => 'eager', 'decoding' => 'async'], true, 0);
}

// Container
$wrapper = $params->get('fluidContainer') ? 'wrapper-fluid' : 'wrapper-static';

$this->setMetaData('viewport', 'width=device-width, initial-scale=1');

// Defer font awesome
$wa->getAsset('style', 'fontawesome')->setAttribute('rel', 'lazy-stylesheet');
?>
<!DOCTYPE html>
<html class="error-site-html" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">

<head>
    <jdoc:include type="metas" />
    <jdoc:include type="styles" />
    <jdoc:include type="scripts" />
</head>

<body class="site error-site<?php echo $bodyClass; ?>">
    <?php if (!$this->debug) : ?>
        <div class="error-background" aria-hidden="true" tabindex="-1">
            <div class="x1">
                <div class="cloud"></div>
            </div>
            <div class="x2">
                <div class="cloud"></div>
            </div>
            <div class="x3">
                <div class="cloud"></div>
            </div>
            <div class="x4">
                <div class="cloud"></div>
            </div>
            <div class="x5">
                <div class="cloud"></div>
            </div>
        </div>
        <div class="error-site-outer">
            <div class="error-site-container">
                <div class="error-code">
                    <div class="error-icon" aria-hidden="true" tabindex="-1">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="120" height="120" viewBox="0 0 64 64">
                            <path d="M27.515 39.735c-0.832 0-1.663-0.317-2.298-0.952-5.946-5.946-5.946-15.621 0-21.567l12-12c2.88-2.88 6.71-4.467 10.783-4.467s7.903 1.586 10.784 4.466c5.946 5.946 5.946 15.621 0 21.567l-5.485 5.485c-1.269 1.269-3.327 1.269-4.596 0s-1.269-3.327 0-4.596l5.485-5.485c3.412-3.412 3.412-8.963 0-12.374-1.653-1.653-3.85-2.563-6.187-2.563s-4.535 0.91-6.187 2.563l-12 12c-3.412 3.412-3.412 8.963 0 12.374 1.269 1.269 1.269 3.327 0 4.596-0.634 0.635-1.466 0.952-2.298 0.952z" fill="#003470"></path>
                            <path d="M16 63.25c-4.073 0-7.903-1.586-10.783-4.466-5.946-5.946-5.946-15.621 0-21.567l5.485-5.485c1.269-1.269 3.327-1.269 4.596 0s1.269 3.327 0 4.596l-5.485 5.485c-3.412 3.412-3.412 8.963 0 12.374 1.652 1.653 3.85 2.563 6.187 2.563s4.535-0.91 6.187-2.563l12-12c3.412-3.412 3.412-8.963 0-12.374-1.269-1.269-1.269-3.327 0-4.596s3.327-1.269 4.596 0c5.946 5.946 5.946 15.621 0 21.567l-12 12c-2.881 2.88-6.71 4.467-10.784 4.467z" fill="#003470"></path>
                            <path d="M58 52c-0.512 0-1.024-0.195-1.414-0.586l-8-8c-0.781-0.781-0.781-2.047 0-2.828s2.047-0.781 2.828 0l8 8c0.781 0.781 0.781 2.047 0 2.828-0.391 0.391-0.902 0.586-1.414 0.586z" fill="#003470"></path>
                            <path d="M62 40h-8c-1.105 0-2-0.895-2-2s0.895-2 2-2h8c1.105 0 2 0.895 2 2s-0.895 2-2 2z" fill="#003470"></path>
                            <path d="M46 56c-1.105 0-2-0.895-2-2v-8c0-1.105 0.895-2 2-2s2 0.895 2 2v8c0 1.105-0.895 2-2 2z" fill="#003470"></path>
                            <path d="M10 28h-8c-1.105 0-2-0.895-2-2s0.895-2 2-2h8c1.104 0 2 0.895 2 2s-0.895 2-2 2z" fill="#003470"></path>
                            <path d="M14 24c-0.512 0-1.024-0.195-1.414-0.586l-8-8c-0.781-0.781-0.781-2.047 0-2.828s2.047-0.781 2.828 0l8 8c0.781 0.781 0.781 2.047 0 2.828-0.39 0.391-0.902 0.586-1.414 0.586z" fill="#003470"></path>
                            <path d="M18 20c-1.105 0-2-0.895-2-2v-8c0-1.104 0.895-2 2-2s2 0.896 2 2v8c0 1.105-0.895 2-2 2z" fill="#003470"></path>
                        </svg>
                    </div>
                    <?php echo $this->error->getCode(); ?>
                </div>
                <h1 class="error-message">
                    <?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8'); ?>
                </h1>
                <p class="error-info">
                    <?php echo Text::_('JERROR_LAYOUT_PAGE_NOT_FOUND'); ?>
                </p>
                <div class="home-page">
                    <a href="<?php echo $this->baseurl; ?>/index.php" class="btn btn-warning">
                        <?php echo Text::_('JERROR_LAYOUT_GO_TO_THE_HOME_PAGE'); ?>
                    </a>
                </div>
            </div>
        </div>
    <?php else : ?>
        <header class="header-content">
            <div class="header-main">
                <div class="<?php echo $containerClass; ?>">
                    <div class="container-inner">
                        <div class="d-flex d-lg-none flex-row flex-nowrap justify-content-between align-items-center gap-4">
                            <div class="mobile-header-center d-flex flex-row justify-content-center align-items-center">
                                <a class="brand-logo" href="<?php echo $this->baseurl; ?>/">
                                    <?php echo $smallLogo; ?>
                                </a>
                            </div>
                            <div class="mobile-header-right d-flex flex-row justify-content-end align-items-center">
                                <?php if ($this->countModules('search', true)) : ?>
                                    <a href="#headerSearch" class="d-inline-block link-inherit-color btn-icon" role="button" aria-controls="headerSearch" aria-label="<?php echo htmlspecialchars(Text::_('JSEARCH_FILTER'), ENT_QUOTES, 'UTF-8'); ?>" data-tmpl-toggle="search">
                                        <i class="vpi vpi-search vpi-lg" aria-hidden="true"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="d-block d-lg-flex flex-row flex-nowrap justify-content-between align-items-center gap-5">
                            <div class="header-left d-none d-lg-flex align-items-center justify-content-start">
                                <div class="site-logo">
                                    <a class="brand-logo" href="<?php echo $this->baseurl; ?>/">
                                        <?php echo $logo; ?>
                                    </a>
                                </div>
                            </div>
                            <?php if ($this->countModules('search', true)) : ?>
                                <div id="headerSearch" class="header-search-container flex-grow-1">
                                    <div class="header-search-inner d-flex justify-content-start align-items-center gap-2">
                                        <a href="#headerSearch" class="d-inline-block d-lg-none link-inherit-color py-1 pe-2" role="button" aria-controls="headerSearch" aria-label="<?php echo htmlspecialchars(Text::_('JCLOSE'), ENT_QUOTES, 'UTF-8'); ?>" data-tmpl-toggle="search">
                                            <i class="vpi vpi-arrow-left vpi-lg" aria-hidden="true"></i>
                                        </a>
                                        <div class="flex-grow-1">
                                            <jdoc:include type="modules" name="search" style="none" />
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <div class="site-content">
            <div class="error-content-area">
                <div class="<?php echo $containerClass; ?>">
                    <div class="container-inner">
                        <h1 class="page-header">
                            <?php echo Text::_('JERROR_LAYOUT_PAGE_NOT_FOUND'); ?>
                        </h1>
                        <div class="card">
                            <div class="card-body">
                                <jdoc:include type="message" />
                                <p>
                                    <strong><?php echo Text::_('JERROR_LAYOUT_ERROR_HAS_OCCURRED_WHILE_PROCESSING_YOUR_REQUEST'); ?></strong>
                                </p>
                                <p>
                                    <?php echo Text::_('JERROR_LAYOUT_NOT_ABLE_TO_VISIT'); ?>
                                </p>
                                <ul>
                                    <li>
                                        <?php echo Text::_('JERROR_LAYOUT_AN_OUT_OF_DATE_BOOKMARK_FAVOURITE'); ?>
                                    </li>
                                    <li>
                                        <?php echo Text::_('JERROR_LAYOUT_MIS_TYPED_ADDRESS'); ?>
                                    </li>
                                    <li>
                                        <?php echo Text::_('JERROR_LAYOUT_SEARCH_ENGINE_OUT_OF_DATE_LISTING'); ?>
                                    </li>
                                    <li>
                                        <?php echo Text::_('JERROR_LAYOUT_YOU_HAVE_NO_ACCESS_TO_THIS_PAGE'); ?>
                                    </li>
                                </ul>
                                <p>
                                    <?php echo Text::_('JERROR_LAYOUT_GO_TO_THE_HOME_PAGE'); ?>
                                </p>
                                <p>
                                    <a href="<?php echo $this->baseurl; ?>/index.php" class="btn btn-secondary">
                                        <span class="icon-home" aria-hidden="true"></span> <?php echo Text::_('JERROR_LAYOUT_HOME_PAGE'); ?>
                                    </a>
                                </p>
                                <hr>
                                <p>
                                    <?php echo Text::_('JERROR_LAYOUT_PLEASE_CONTACT_THE_SYSTEM_ADMINISTRATOR'); ?>
                                </p>
                                <blockquote>
                                    <span class="badge bg-secondary"><?php echo $this->error->getCode(); ?></span> <?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8'); ?>
                                </blockquote>
                                <?php if ($this->debug) : ?>
                                    <div>
                                        <?php echo $this->renderBacktrace(); ?>
                                        <?php // Check if there are more Exceptions and render their data as well
                                        ?>
                                        <?php if ($this->error->getPrevious()) : ?>
                                            <?php $loop = true; ?>
                                            <?php // Reference $this->_error here and in the loop as setError() assigns errors to this property and we need this for the backtrace to work correctly
                                            ?>
                                            <?php // Make the first assignment to setError() outside the loop so the loop does not skip Exceptions
                                            ?>
                                            <?php $this->setError($this->_error->getPrevious()); ?>
                                            <?php while ($loop === true) : ?>
                                                <p><strong><?php echo Text::_('JERROR_LAYOUT_PREVIOUS_ERROR'); ?></strong></p>
                                                <p><?php echo htmlspecialchars($this->_error->getMessage(), ENT_QUOTES, 'UTF-8'); ?></p>
                                                <?php echo $this->renderBacktrace(); ?>
                                                <?php $loop = $this->setError($this->_error->getPrevious()); ?>
                                            <?php endwhile; ?>
                                            <?php // Reset the main error object to the base error
                                            ?>
                                            <?php $this->setError($this->error); ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <jdoc:include type="modules" name="debug" style="none" />
</body>

</html>
