<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Virtueplanet\Plugin\System\Prime\Helper\GoogleFontHelper;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;

/** @var Joomla\CMS\Document\HtmlDocument $this */

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app = Factory::getApplication();
$wa  = $this->getWebAssetManager();

/** @var Joomla\Registry\Registry $params */
$params = $this->params;

// Browsers support SVG favicons
$faviconSvg = $params->get('favicon_svg', '');

if (!empty($faviconSvg)) {
    $this->addHeadLink(Uri::root(true) . '/images/' . $faviconSvg, 'icon', 'rel', ['type' => 'image/svg+xml']);
} else {
    $this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
}

// Add ICO favicon.
$favicon = $params->get('favicon', '');

if (!empty($favicon)) {
    $this->addHeadLink(Uri::root(true) . '/images/' . $favicon, 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
} else {
    $this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
}

// Add Pinned Tab Icon
$pinnedTabIcon      = $params->get('pinned_tab_icon', '');
$pinnedTabIconColor = $params->get('pinned_tab_icon_color', '#000000');

if (!empty($pinnedTabIcon)) {
    $this->addHeadLink(Uri::root(true) . '/images/' . $pinnedTabIcon, 'mask-icon', 'rel', ['color' => $pinnedTabIconColor]);
} else {
    $this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => $pinnedTabIconColor]);
}

// Detecting Active Variables
$option     = strtolower($app->input->getCmd('option', ''));
$view       = strtolower($app->input->getCmd('view', ''));
$layout     = strtolower($app->input->getCmd('layout', ''));
$task       = strtolower($app->input->getCmd('task', ''));
$itemid     = $app->input->getInt('Itemid', 0);
$print      = $app->input->getInt('print', 0);
$tmpl       = strtolower($app->input->getCmd('tmpl', ''));
$manage     = $app->input->getInt('manage', 0);
$sitename   = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu       = $app->getMenu()->getActive();
$pageclass  = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';
$bodyClass  = ($option ? ' ' . str_replace('_', '-', $option) : '') .
    ($view ? ' view-' . $view : ' no-view') .
    ($layout ? ' layout-' . $layout : ' no-layout') .
    ($task ? ' task-' . $task : ' no-task') .
    ($itemid ? ' itemid-' . $itemid : '') .
    ($pageclass ? ' ' . $pageclass : '') .
    ($this->direction === 'rtl' ? ' rtl' : ' ltr');
$onLoadAttr = !empty($print) ? ' onload="javascript:print();"' : '';

// Use a font scheme if set in the template style options
$paramsFontScheme = $params->get('use_font_scheme', 'media/templates/site/vp_neoteric/css/global/fonts-local_roboto.css');

if ($paramsFontScheme) {
    if ($paramsFontScheme === 'google') {
        $bodyFontName       = $params->get('google_font_name', '');
        $bodyFontVariant    = $params->get('google_font_variant', '');
        $addFontVariants    = $params->get('google_font_additional_variants', []);
        $headingFontName    = $params->get('heading_google_font_name', '');
        $headingFontVariant = $params->get('heading_google_font_variant', '');
        $gfontsJsonFile     = 'media/templates/site/vp_neoteric/webfonts/gfonts.json';
        $fontStyles         = '';

        if ($bodyFontName || $headingFontName) {
            $this->getPreloadManager()->preconnect('https://fonts.googleapis.com/', ['crossorigin' => 'anonymous']);
            $this->getPreloadManager()->preconnect('https://fonts.gstatic.com/', ['crossorigin' => 'anonymous']);

            if ($bodyFontName) {
                GoogleFontHelper::addFontFamily($bodyFontName, $bodyFontVariant);

                if (!empty($addFontVariants)) {
                    GoogleFontHelper::addFontFamily($bodyFontName, $addFontVariants);
                }

                $fontInfo = GoogleFontHelper::getFontInfo($bodyFontName, $bodyFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-body: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-normal: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-normal: ' . $fontInfo->style . ";\n";
                }
            }

            if ($headingFontName) {
                GoogleFontHelper::addFontFamily($headingFontName, $headingFontVariant);

                $fontInfo = GoogleFontHelper::getFontInfo($headingFontName, $headingFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-headings: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-headings: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-headings: ' . $fontInfo->style . ";\n";
                }
            }

            $fontStyleUrl = GoogleFontHelper::getAddedFontsUrl();

            if ($fontStyleUrl) {
                $this->getPreloadManager()->preload($fontStyleUrl, ['as' => 'style', 'crossorigin' => 'anonymous']);

                if ($params->get('lazyload_google_fonts', 1)) {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'print', 'rel' => 'lazy-stylesheet', 'onload' => 'this.media=\'all\'', 'crossorigin' => 'anonymous']);
                } else {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'all', 'crossorigin' => 'anonymous']);
                }
            }
        }

        if (!empty($fontStyles)) {
            $wa->addInlineStyle(":root {\n" . $fontStyles . "}");
        }
    } else {
        $wa->registerAndUseStyle('fontscheme.current', $paramsFontScheme, ['version' => 'auto'], ['media' => 'all']);
        $this->getPreloadManager()->preload($wa->getAsset('style', 'fontscheme.current')->getUri() . '?' . $this->getMediaVersion(), ['as' => 'style']);
    }
}

// Enable assets
$wa->usePreset('template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr'))
    ->useStyle('template.active.language')
    ->useStyle('template.user')
    ->useScript('template.user');

// Add CSS variables
$cssVariables    = TemplateHelper::getCSSVariables($params, __DIR__, 'style');
$cssVariablesStr = '';

foreach ($cssVariables as $name => $value) {
    $cssVariablesStr .= $name . ': ' . $value . ';' . "\n";
}

$cssVariablesStr = ':root {' . "\n" . $cssVariablesStr . '}';

$wa->addInlineStyle($cssVariablesStr);

// Override 'template.active' asset to set correct ltr/rtl dependency
$wa->registerStyle('template.active', '', [], [], ['template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr')]);

$this->setMetaData('viewport', 'width=device-width, initial-scale=1');

// Defer fontawesome for increased performance. Once the page is loaded javascript changes it to a stylesheet.
$wa->getAsset('style', 'fontawesome')->setAttribute('rel', 'lazy-stylesheet');
$this->getPreloadManager()->preload($wa->getAsset('style', 'fontawesome')->getUri() . '?' . $this->getMediaVersion(), ['as' => 'style']);

// Unload unnecessary assets except when VirtueMart's front end editing mode.
if (($option === 'com_virtuemart' && $manage) === false) {
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-ltr-common.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-ltr-site.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-ltr-reviews.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vmpanels.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vmsite-ltr.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vmsite-rtl.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-bs3-common.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-bs4-common.css');
    TemplateHelper::enqueueToUnloadAssets('styleSheets', 'components/com_virtuemart/assets/css/vm-bs5-common.css');
    TemplateHelper::enqueueToUnloadAssets('scripts', 'components/com_virtuemart/assets/js/cvfind.js');
}

// Unload unnecessary assets loaded by VirtueMart Essentials
TemplateHelper::enqueueToUnloadAssets('styleSheets', 'media/com_vmessentials/css/font-awesome.css');
TemplateHelper::enqueueToUnloadAssets('styleSheets', 'media/com_vmessentials/css/font-awesome.min.css');
TemplateHelper::enqueueToUnloadAssets('styleSheets', 'media/com_vmessentials/css/iframe-modal.css');
TemplateHelper::enqueueToUnloadAssets('styleSheets', 'media/com_vmessentials/css/iframe-modal.min.css');
TemplateHelper::enqueueToUnloadAssets('scripts', 'media/com_vmessentials/js/iframe-modal.js');
TemplateHelper::enqueueToUnloadAssets('scripts', 'media/com_vmessentials/js/iframe-modal.min.js');

// Change VirtueMart Essentials Configuration.
$comVMEssentialsParams = ComponentHelper::getParams('com_vmessentials');
$comVMEssentialsParams->set('auto_buttons', 0);

// Prepare custom codes.
$customCodeBeforeHead = $params->get('custom_codes_before_head', '');
$customCodeAfterBody  = $params->get('custom_codes_after_body', '');
$customCodeBeforeBody = $params->get('custom_codes_before_body', '');
$customCSS            = $params->get('custom_css', '');
$customCSS            = trim($customCSS);
$customCSS            = !empty($customCSS) ? '<style>' . "\n" . $customCSS . "\n" . '</style>' : '';
$customJavascript     = $params->get('custom_js', '');
$customJavascript     = trim($customJavascript);
$customJavascript     = !empty($customJavascript) ? '<script>' . "\n" . $customJavascript . "\n" . '</script>' : '';
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">

<head>
    <jdoc:include type="metas" />
    <jdoc:include type="styles" />
    <jdoc:include type="scripts" />
    <?php echo $customCodeBeforeHead; ?>
    <?php echo $customCSS; ?>
</head>

<body class="tmpl-component <?php echo $bodyClass; ?>" <?php echo $onLoadAttr; ?>>
    <?php echo $customCodeAfterBody; ?>
    <jdoc:include type="message" />
    <jdoc:include type="component" />
    <?php echo $customCodeBeforeBody; ?>
    <?php echo $customJavascript; ?>
</body>

</html>
