<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 * @phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
 */

use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Virtueplanet\Plugin\System\Prime\Framework\AjaxMethods;
use Virtueplanet\Plugin\System\Prime\Framework\PluginTrait;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;

include_once __DIR__ . '/includes/defines.php';
include_once __DIR__ . '/includes/debugger.php';
// phpcs:enable PSR1.Files.SideEffects

/**
 * VP Prime Framework plugin.
 */
class PlgSystemVpprime extends CMSPlugin
{
    use PluginTrait;

    /**
     * Load the language file on instantiation.
     *
     * @var  boolean
     */
    protected $autoloadLanguage = true;

    /**
     * Application object.
     *
     * @var  \Joomla\CMS\Application\CMSApplication
     */
    protected $app;

    /**
     * Adds additional fields to the user editing form
     *
     * @param   Form   $form  The form to be altered.
     * @param   mixed  $data  The associated data for the form.
     *
     * @return  boolean
     */
    public function onContentPrepareForm(Form $form, $data)
    {
        $this->addFrameworkParams($form, $data);
        $this->processParamForms($form, $data);
    }

    /**
     * If logged in users haven't agreed to privacy consent, redirect them to profile edit page, ask them to agree to
     * privacy consent before allowing access to any other pages
     *
     * @return  void
     */
    public function onAfterRoute()
    {
        // Run this in frontend only
        if ($this->app->isClient('administrator')) {
            return;
        }

        $this->processRoutes();
    }

    /**
    * Before head compile events
    *
    * @return void
    */
    public function onBeforeCompileHead()
    {
        // Run this in frontend only
        if ($this->app->isClient('administrator')) {
            return;
        }

        $this->prepareAssets();
    }

    /**
     * After render.
     *
     * @return  void
     */
    public function onAfterRender()
    {
        if ($this->app->isClient('administrator')) {
            return;
        }

        $this->finalise();
    }

    /**
     * Called by Ajax interface component.
     *
     * @return  void
     */
    public function onAjaxVpprime()
    {
        $ajaxMethods = AjaxMethods::getInstance();
        $method      = $this->app->input->getCmd('method', '');

        if ($method && method_exists($ajaxMethods, $method)) {
            return $ajaxMethods->{$method}();
        }
    }
}
