<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Service\HTML;

use Joomla\CMS\Factory;
use Virtueplanet\Plugin\System\Prime\Helper\ScriptHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * HTML class for Module.
 */
abstract class Module
{
    protected static $scrollRevealLoaded = false;

    public static function scrollReveal($module, $params, $htmlSelector)
    {
        /** @var \Joomla\CMS\Application\SiteApplication $app */
        $app      = Factory::getApplication();
        $document = $app->getDocument();
        $wa       = $document->getWebAssetManager();

        // Check if ScrollReveal is available.
        if (!$wa->assetExists('preset', 'template.scrollreveal')) {
            return;
        }

        // ScrollReveal is disabled in the module settings.
        if (!$params->get('scroll-reveal', 0)) {
            return;
        }

        if (!self::$scrollRevealLoaded) {
            $wa->useScript('core')
                ->usePreset('template.scrollreveal');

            self::$scrollRevealLoaded = true;
        }

        $config = [
            'origin'     => $params->get('sr-origin', 'bottom'),
            'distance'   => $params->get('sr-distance', '20px'),
            'duration'   => (int) $params->get('sr-duration', 500),
            'delay'      => (int) $params->get('sr-delay', 0),
            'opacity'    => (float) $params->get('sr-opacity', 0),
            'scale'      => (float) $params->get('sr-scale', 0.9),
            'easing'     => $params->get('sr-easing', 'ease'),
            'mobile'     => (bool) $params->get('sr-mobile', 1),
            'reset'      => (bool) $params->get('sr-reset', 0),
            'useDelay'   => $params->get('sr-useDelay', 'always'),
            'viewFactor' => (float) $params->get('sr-viewFactor', 0.2)
        ];

        $options = [
            'selector' => $htmlSelector,
            'config'   => $config
        ];

        $scriptOptions = ScriptHelper::getScriptOptions('template.scrollreveal');

        if (empty($scriptOptions) || !is_array($scriptOptions)) {
            $scriptOptions = [];
        }

        $scriptOptions[] = $options;

        ScriptHelper::addScriptOptions('template.scrollreveal', $scriptOptions, false);

        $wa->addInlineStyle($htmlSelector . '{visibility: hidden;}');
    }
}
