<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Helper;

use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Script Helper class of VP Prime Framework.
 */
class ScriptHelper
{
    protected static $scriptOptions = [];

    /**
     * Add option for script
     *
     * @param   string  $key      Name in Storage
     * @param   mixed   $options  Scrip options as array or string
     * @param   bool    $merge    Whether merge with existing (true) or replace (false)
     *
     * @return  void
     */
    public static function addScriptOptions($key, $options, $merge = true)
    {
        $globalHelper  = GlobalHelper::getInstance();
        $scriptOptions = $globalHelper->getData('vpprime.script.options', []);

        if (empty($scriptOptions[$key])) {
            $scriptOptions[$key] = [];
        }

        if ($merge && \is_array($options)) {
            $scriptOptions[$key] = array_replace_recursive($scriptOptions[$key], $options);
        } else {
            $scriptOptions[$key] = $options;
        }

        $globalHelper->setData('vpprime.script.options', $scriptOptions);
    }

    /**
     * Get script(s) options
     *
     * @param   string  $key  Name in Storage
     *
     * @return  array  Options for given $key, or all script options
     */
    public static function getScriptOptions($key = null)
    {
        $scriptOptions = GlobalHelper::getInstance()->getData('vpprime.script.options', []);

        if ($key) {
            return (empty($scriptOptions[$key])) ? [] : $scriptOptions[$key];
        } else {
            return $scriptOptions;
        }
    }

    /**
     * Load all script options
     *
     * @return  void
     */
    public static function loadAll()
    {
        /** @var \Joomla\CMS\Application\SiteApplication $app */
        $app           = Factory::getApplication();
        $document      = $app->getDocument();
        $scriptOptions = GlobalHelper::getInstance()->getData('vpprime.script.options', []);

        foreach ($scriptOptions as $scriptOption) {
            $document->addScriptOptions('template.scrollreveal', $scriptOption, false);
        }
    }
}
