<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper as CoreModuleHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\Registry\Registry;
use Virtueplanet\Plugin\System\Prime\Object\ModuleMenu;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Module Helper class of VP Prime Framework.
 */
abstract class ModuleHelper
{
    /**
     * List of loaded modules.
     *
     * @var   array
     */
    protected static $modules = [];

    public static function getForMenu($moduleId, $calledMenuItem = null)
    {
        $module = self::get($moduleId);

        if (!$module) {
            return;
        }

        $item = new ModuleMenu($module, $calledMenuItem);

        if ($calledMenuItem) {
            $params = new Registry();

            $params->set('menu_show', 1);

            $item->setParams($params);

            $item->parent_id = $calledMenuItem->parent_id;

            $item->setParent($calledMenuItem->getParent());
        }

        $item->buildTree();

        $item->render();

        return $item;
    }

    public static function get($moduleId)
    {
        $moduleId = (int) $moduleId;

        if ($moduleId <= 0) {
            return;
        }

        if (!isset(self::$modules[$moduleId])) {
            $db    = Factory::getContainer()->get(DatabaseInterface::class);
            $query = $db->getQuery(true);
            $user  = Factory::getApplication()->getIdentity();

            $query->select($db->quoteName(['id', 'title', 'module', 'position', 'content', 'showtitle', 'params']))
                ->from($db->quoteName('#__modules'))
                ->where($db->quoteName('id') . ' = ' . $moduleId)
                ->where($db->quoteName('published') . ' = 1')
                ->where($db->quoteName('access') . ' IN (' . implode(',', $db->quote($user->getAuthorisedViewLevels())) . ')');

            $db->setQuery($query);
            self::$modules[$moduleId] = $db->loadObject();
        }

        return self::$modules[$moduleId];
    }

    public static function getByPositionForMenu($position, $calledMenuItem = null)
    {
        $modules = CoreModuleHelper::getModules($position);
        $items   = [];

        foreach ($modules as $module) {
            $item = new ModuleMenu($module, $calledMenuItem);

            if ($calledMenuItem) {
                $params = new Registry();

                $params->set('menu_show', 1);

                $item->setParams($params);

                $item->parent_id = $calledMenuItem->parent_id;

                $item->setParent($calledMenuItem->getParent());
            }

            $item->buildTree();

            $item->render();

            $items[] = $item;
        }

        return $items;
    }
}
