<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Helper;

use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Json Helper class of VP Prime Framework.
 */
abstract class JsonHelper
{
    /**
     * Method to print JSON output
     *
     * @param    array|object   $data   The data to be printed
     *
     * @return   void
     */
    public static function return($data)
    {
        $obLevel = ob_get_level();

        if ($obLevel) {
            while ($obLevel > 0) {
                ob_end_clean();
                $obLevel--;
            }
        } else {
            ob_clean();
        }

        if (isset($_SERVER['HTTP_ACCEPT']) && (strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false)) {
            header('Content-type: application/text');
        } else {
            header('Content-type: application/json');
        }

        header('Cache-Control: public,max-age=1,must-revalidate');
        header('Expires: ' . gmdate('D, d M Y H:i:s', ($_SERVER['REQUEST_TIME'] + 1)) . ' GMT');
        header('Last-modified: ' . gmdate('D, d M Y H:i:s', $_SERVER['REQUEST_TIME']) . ' GMT');

        if (function_exists('header_remove')) {
            header_remove('Pragma');
        }

        echo json_encode($data);

        Factory::getApplication()->close();
    }
}
