<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\Exception\ExecutionFailureException;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content Helper class of VP Prime Framework.
 */
class ContentHelper
{
    public static function getArticleUrl($articleId, $tmpl = null)
    {
        $db    = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true);

        // Get the info from the article
        $query = $db->getQuery(true)
            ->select($db->quoteName(['id', 'catid', 'language']))
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('id') . ' = ' . (int) $articleId);
        $db->setQuery($query);

        try {
            $article = $db->loadObject();
        } catch (ExecutionFailureException $e) {
            // Something at the database layer went wrong
            return Route::_(
                'index.php?option=com_content&view=article&id='
                . $articleId . ($tmpl ? '&tmpl=' . $tmpl : '')
            );
        }

        if (!\is_object($article)) {
            // We have not found the article object lets show a 404 to the user
            return Route::_(
                'index.php?option=com_content&view=article&id='
                . $articleId . ($tmpl ? '&tmpl=' . $tmpl : '')
            );
        }

        if (!Associations::isEnabled()) {
            return Route::_(
                RouteHelper::getArticleRoute(
                    $article->id,
                    $article->catid,
                    $article->language
                ) . '&tmpl=component'
            );
        }

        $associatedArticles = Associations::getAssociations('com_content', '#__content', 'com_content.item', $article->id);
        $currentLang        = Factory::getLanguage()->getTag();

        if (isset($associatedArticles) && $currentLang !== $article->language && \array_key_exists($currentLang, $associatedArticles)) {
            return Route::_(
                RouteHelper::getArticleRoute(
                    $associatedArticles[$currentLang]->id,
                    $associatedArticles[$currentLang]->catid,
                    $associatedArticles[$currentLang]->language
                ) . ($tmpl ? '&tmpl=' . $tmpl : '')
            );
        }

        // Association is enabled but this article is not associated
        return Route::_(
            'index.php?option=com_content&view=article&id='
                . $article->id . '&catid=' . $article->catid
                . ($tmpl ? '&tmpl=' . $tmpl : '') . '&lang=' . $article->language
        );
    }
}
