<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Framework;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormHelper;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;
use Virtueplanet\Plugin\System\Prime\Helper\ScriptHelper;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

trait PluginTrait
{
    /**
     * Application object.
     *
     * @var  \Joomla\CMS\Application\CMSApplication
     */
    protected $app;

    /**
     * Adds additional fields to the user editing form
     *
     * @param   Form   $form  The form to be altered.
     * @param   mixed  $data  The associated data for the form.
     *
     * @return  boolean
     */
    private function addFrameworkParams(Form $form, $data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (!empty($data['client_id'])) {
            // Skip admin
            return;
        }

        // Check we are manipulating a valid form.
        $context = $form->getName();

        if (!in_array($context, ['com_menus.item', 'com_modules.module', 'com_config.modules', 'com_advancedmodules.module'])) {
            return;
        }

        FormHelper::addFieldPrefix('Virtueplanet\\Plugin\\System\\Prime\\Field');
        FormHelper::addFormPath(VP_PRIME_FRAMEWORK_PATH . '/forms');

        if ($context == 'com_menus.item') {
            $form->loadFile('menu', false);
        } elseif ($context == 'com_modules.module' || $context == 'com_config.modules' || $context == 'com_advancedmodules.module') {
            $form->loadFile('module', false);
        }
    }

    /**
     * Process param forms as necessary.
     *
     * @param   Form   $form  The form to be altered.
     * @param   mixed  $data  The associated data for the form.
     *
     * @return  boolean
     */
    private function processParamForms(Form $form, $data)
    {
        // Check we are manipulating a valid form.
        $context = $form->getName();

        // Remove VirtueMart parameters from the template settings if VirtueMart is not installed.
        if ($context === 'com_templates.style' && !VirtuemartHelper::isInstalled()) {
            $xml = $form->getXml();

            if ($xml instanceof \SimpleXMLElement) {
                $fieldsetName = 'virtuemart';
                $fieldsets    = $xml->xpath('//fieldset[@name="' . $fieldsetName . '"][not(ancestor::field/form/*)]');

                foreach ($fieldsets as &$fieldset) {
                    $dom = dom_import_simplexml($fieldset);

                    $dom->parentNode->removeChild($dom);
                }
            }
        }
    }

    private function prepareAssets()
    {
        $document = $this->app->getDocument();

        if ($document->getType() === 'html') {
            TemplateHelper::unloadAssets();
            TemplateHelper::loadCustomAssets();
            VirtuemartHelper::finalizeAssets();
            ScriptHelper::loadAll();
        }
    }

    private function processRoutes()
    {
        VirtuemartHelper::setProductListMode();
    }

    private function finalise()
    {
        // Store global data to cache
        GlobalHelper::getInstance()->storeDataToCache();
    }
}
