<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class VmmanufacturerField extends ListField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'vmmanufacturer';

    public function getOptions()
    {
        \JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

        \VmConfig::loadConfig();

        /** @var \VirtueMartModelManufacturer  $model */
        $model         = \VmModel::getModel('Manufacturer');
        $manufacturers = $model->getManufacturers(false, true, false);
        $options       = [];

        if (!empty($manufacturers)) {
            foreach ($manufacturers as $manufacturer) {
                $value = (int) $manufacturer->virtuemart_manufacturer_id;
                $text  = htmlspecialchars($manufacturer->mf_name, ENT_COMPAT, 'UTF-8', false);

                $options[] = HTMLHelper::_('select.option', $value, $text);
            }
        }

        return array_merge(parent::getOptions(), $options);
    }
}
