<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Virtueplanet\Plugin\System\Prime\Service\HTML\Virtuemart;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Provides VirtueMart Category selection field.
 */
class VirtuemartcategoryField extends ListField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'virtuemartcategory';

    /**
     * Method to get the field input markup.
     *
     * @return  string   The field input markup.
     */
    protected function getOptions()
    {
        if ($this->multiple) {
            $this->layout = 'joomla.form.field.list-fancy-select';
        }

        $serviceRegistry = HTMLHelper::getServiceRegistry();

        if (!$serviceRegistry->hasService('vpprime_virtuemart')) {
            $serviceRegistry->register('vpprime_virtuemart', Virtuemart::class);
        }

        $options = HTMLHelper::_('vpprime_virtuemart.categoryOptions');

        return array_merge(parent::getOptions(), $options);
    }
}
