<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SitepreviewField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'sitepreview';

    public function getInput()
    {
        /** @var \Joomla\CMS\Application\SiteApplication $app */
        $app      = Factory::getApplication();
        $document = $app->getDocument();
        $wa       = $document->getWebAssetManager();

        $wa->registerAndUseScript('vpprime.field.sitepreview', 'plg_system_vpprime/field/sitepreview.js', ['version' => 'v1.0']);
        $wa->registerAndUseStyle('vpprime.field.sitepreview', 'plg_system_vpprime/field/sitepreview.css', ['version' => 'v1.0']);

        $html = [];

        $html[] = '<div class="sitepreview">';
        $html[] = '<div class="sitepreview-toolbar d-flex flex-row gap-2 justify-content-between align-items-center mb-4">';
        $html[] = '<div class="d-flex flex-row justify-content-start align-items-center gap-3">';
        $html[] = '<label for="prev-scale-to-fit" id="prev-scale-to-fit-lbl">Scale to Fit</label>';
        $html[] = '<fieldset id="prev-scale-to-fit">';
        $html[] = '<div class="switcher">';
        $html[] = '<input type="radio" id="prev_scale_to_fit1" name="prev_scale_to_fit" value="0" />';
        $html[] = '<label for="prev_scale_to_fit1">No</label>';
        $html[] = '<input type="radio" id="prev_scale_to_fit0" name="prev_scale_to_fit" value="1" checked="checked" />';
        $html[] = '<label for="prev_scale_to_fit0">Yes</label>';
        $html[] = '<span class="toggle-outside"><span class="toggle-inside"></span></span>';
        $html[] = '</div>';
        $html[] = '</fieldset>';
        $html[] = '</div>';
        $html[] = '<button type="button" class="btn btn-sm btn-outline-secondary pull-right float-end" data-refreshpreview="1"><i class="icon-loop"></i>&nbsp;&nbsp;Refresh</button>';
        $html[] = '</div>';
        $html[] = '<div class="sitepreview-container sitepreviw-loading">';
        $html[] = '<iframe class="sitepreview-frame" src="about:blank" data-src="' . Uri::root() . '" width="100%" border="0"></iframe>';
        $html[] = '<div class="sitepreview-loader" aria-hidden="true"></div>';
        $html[] = '</div>';
        $html[] = '</div>';

        return implode("\n", $html);
    }

    public function getLabel()
    {
        return '';
    }
}
