<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Layout\FileLayout;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;
use Virtueplanet\Plugin\System\Prime\Helper\UpdateHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class PrimeadminField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'primeadmin';

    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'vpprime.form.field.primeadmin';

    /**
     * Name of the Dlk form layout being used to render the field
     *
     * @var    string
     */
    protected $dlkFormLayout = 'vpprime.form.field.primeadmin.dlkform';

    public function getInput()
    {
        return $this->getRenderer($this->layout)->render($this->getLayoutData());
    }

    public function getLabel()
    {
        return '';
    }

    /**
     * Method to get the data to be passed to the layout for rendering.
     *
     * @return  array
     */
    protected function getLayoutData()
    {
        $data       = parent::getLayoutData();
        $input      = Factory::getApplication()->input;
        $templateId = $input->getInt('id', 0);
        $package    = UpdateHelper::getPackage($templateId);
        $template   = TemplateHelper::getTemplateStyle($templateId);

        $extraData = [
            'value'    => $this->value,
            'package'  => $package,
            'template' => $template,
            'dlkForm'  => $this->getRenderer($this->dlkFormLayout)->render()
        ];

        return array_merge($data, $extraData);
    }

    /**
     * Get the renderer
     *
     * @param   string  $layoutId  Id to load
     *
     * @return  FileLayout
     */
    protected function getRenderer($layoutId = 'default')
    {
        $renderer = parent::getRenderer($layoutId);

        $renderer->addIncludePath(VP_PRIME_FRAMEWORK_PATH . DIRECTORY_SEPARATOR . 'layouts');

        return $renderer;
    }
}
