<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Virtueplanet\Plugin\System\Prime\Helper\GoogleFontHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class GfontsField extends ListField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    public $type = 'gfonts';

    protected function getOptions()
    {
        if (empty($this->element['file'])) {
            return parent::getOptions();
        }

        $fonts   = GoogleFontHelper::getItems($this->element['file']);
        $options = [];

        foreach ($fonts as $font) {
            $options[] = HTMLHelper::_('select.option', $font['family'], $font['family']);
        }

        return array_merge(parent::getOptions(), $options);
    }
}
