<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Plugin\System\Prime\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class BootstrapgridField extends ListField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'bootstrapgrid';

    protected static $addCalculationFunction = true;

    public function getOptions()
    {
        $showPerRow = (int) isset($this->element['showperrow']) ? $this->element['showperrow'] : 0;
        $options    = [];

        if ($showPerRow) {
            $options[] = HTMLHelper::_('select.option', 1, 1);
            $options[] = HTMLHelper::_('select.option', 2, 2);
            $options[] = HTMLHelper::_('select.option', 3, 3);
            $options[] = HTMLHelper::_('select.option', 4, 4);
            $options[] = HTMLHelper::_('select.option', 6, 6);
            $options[] = HTMLHelper::_('select.option', 12, 12);
        } else {
            for ($i = 0; $i <= 12; $i++) {
                if ($i === 0) {
                    $options[] = HTMLHelper::_('select.option', $i, Text::_('PLG_SYSTEM_VPPRIME_HIDDEN'));
                } elseif ($i === 12) {
                    $options[] = HTMLHelper::_('select.option', $i, Text::_('PLG_SYSTEM_VPPRIME_FULL_WIDTH'));
                } else {
                    $options[] = HTMLHelper::_('select.option', $i, $i);
                }
            }
        }

        return array_merge($options, parent::getOptions());
    }

    public function getInput()
    {
        $readonly      = isset($this->element['readonly']) ? $this->element['readonly'] : false;
        $bootcalculate = isset($this->element['bootcalculate']) ? $this->element['bootcalculate'] : '';

        if ($readonly && !empty($bootcalculate)) {
            /** @var \Joomla\CMS\Application\SiteApplication $app */
            $app      = Factory::getApplication();
            $document = $app->getDocument();
            $wa       = $document->getWebAssetManager();

            $wa->addInlineScript("
            document.addEventListener('DOMContentLoaded', function() {
                [].slice.call(document.querySelectorAll('" . $bootcalculate . "')).forEach(function (thisElement) {
                    var total = 0;
                    [].slice.call(document.querySelectorAll('" . $bootcalculate . "')).forEach(function (el) {
                        total += parseInt(el.value);
                    });
                    var balance = 12 - total;
                    if (balance == 12) {
                        document.querySelector('#" . $this->id . "').value = 'Full Width';
                    } else if (balance > 0) {
                        document.querySelector('#" . $this->id . "').value = balance;
                    } else {
                        document.querySelector('#" . $this->id . "').value = 'Hidden';
                        [].slice.call(document.querySelectorAll('" . $bootcalculate . "')).forEach(function (el) {
                            if (!el.contains(thisElement)) {
                                el.value = 12 - thisElement.value;
                            }
                        });
                    }

                    thisElement.addEventListener('change', function(e) {
                        var total = 0;
                        [].slice.call(document.querySelectorAll('" . $bootcalculate . "')).forEach(function (el) {
                            total += parseInt(el.value);
                        });
                        var balance = 12 - total;
                        if (balance == 12) {
                            document.querySelector('#" . $this->id . "').value = 'Full Width';
                        } else if (balance > 0) {
                            document.querySelector('#" . $this->id . "').value = balance;
                        } else {
                            document.querySelector('#" . $this->id . "').value = 'Hidden';
                            [].slice.call(document.querySelectorAll('" . $bootcalculate . "')).forEach(function (el) {
                                if (e.target && !el.contains(e.target)) {
                                    el.value = 12 - e.target.value;
                                }
                            });
                        }
                    });
                });
            });
            ");

            $html = '<input type="text" name="' . $this->name . '" id="' . $this->id . '" value="' . (int) $this->value . '" readonly="readonly" class="form-control" />';

            return $html;
        } else {
            return parent::getInput();
        }
    }
}
