<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;
?>
<div id="dlkForm">
    <div class="dlk-message" data-dlkform="message"></div>
    <div class="mb-2">
        <label for="vp-uname" class="form-label">
            <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_UNAME'); ?>
        </label>
        <input type="text" id="vp-uname" class="form-control" data-dlkform="uname" autocomplete="off" spellcheck="false" />
        <div class="form-control-hint text-end">
            <a href="https://www.virtueplanet.com/lost-user-name/" target="_blank"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FORGOT_UNAME'); ?></a>
        </div>
    </div>
    <div class="mb-4">
        <label for="vp-dlk" class="form-label">
            <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_DOWNLOAD_KEY'); ?>
        </label>
        <input type="text" id="vp-dlk" class="form-control" data-dlkform="dlk" autocomplete="off" spellcheck="false" />
        <div class="form-control-hint text-end">
            <a href="https://www.virtueplanet.com/download-key/" target="_blank"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FORGOT_DLK'); ?></a>
        </div>
    </div>
    <button type="button" class="btn btn-primary btn-lg w-100" data-dlkform="submit">
        <span class="dlk-btn-spinner spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
        <?php echo Text::_('JSUBMIT'); ?>
    </button>
</div>