<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app      = Factory::getApplication();
$document = $app->getDocument();
$wa       = $document->getWebAssetManager();

$wa->useScript('core');
$wa->useScript('bootstrap.popover');
$wa->registerAndUseScript('vpprime.field.admin', 'plg_system_vpprime/field/primeadmin.js', ['version' => '1.2']);
$wa->registerAndUseStyle('vpprime.field.admin', 'plg_system_vpprime/field/primeadmin.css', ['version' => '1.2']);

Text::script('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ON_LOAD_ADD_DLK_MESSAGE');
Text::script('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ERROR_UNAME');
Text::script('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ERROR_DLK');
?>
<div class="primeadmin">
    <?php if (!empty($package)) : ?>
        <div class="row">
            <div class="col-lg-6">
                <fieldset class="options-form">
                    <legend>
                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_UPDATE'); ?>
                    </legend>
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_PACKAGE_NAME'); ?>
                                </th>
                                <th class="text-center">
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_VERSION'); ?>
                                </th>
                                <th class="text-center">
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_LATEST_VERSION'); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <?php echo Text::_($package->name); ?>
                                </td>
                                <td class="text-center">
                                    <span class="current-version badge px-2 bg-secondary" data-dclassname="bg-secondary" data-oclassname="bg-danger" data-nclassname="bg-success" data-extensionid="<?php echo $package->extension_id; ?>">
                                        <?php echo $package->version; ?>
                                    </span>
                                </td>
                                <td class="text-center latest-version" data-action="getversion" data-extensionid="<?php echo $package->extension_id; ?>" data-currentversion="<?php echo $package->version; ?>">
                                    <div class="version-loading spinner-border text-success spinner-border-sm" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    <div class="version-error">
                                        <span class="has-tooltip text-danger" title="<?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ERROR_VERSION'); ?>">
                                            <i class="fas fa-times-circle" aria-hidden="true"></i>
                                            <span class="visually-hidden"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ERROR_VERSION'); ?></span>
                                        </span>
                                    </div>
                                </td>
                            </tr>
                            <tr class="update-found d-none">
                                <td colspan="2">
                                    <p>
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_UPDATE_AVAILABLE'); ?> <a data-update="infourl" href="#" target="_blank" class="d-none"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_LEARN_MORE'); ?></a>
                                    </p>
                                    <p data-update="nodlk" class="text-danger d-none">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_UPDATE_MEMBERSHIP_INFO'); ?>
                                    </p>
                                </td>
                                <td class="text-center">
                                    <button data-update="btn" type="button" onclick="window.open('index.php?option=com_installer&view=update');return false;" class="btn btn-primary text-nowrap" <?php echo empty($package->dlkData['dlk']) ? 'disabled' : ''; ?>>
                                        <span class="icon-checkmark" aria-hidden="true"></span>&nbsp;&nbsp;<?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_UPDATE_BTN_LABEL'); ?>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </fieldset>
                <fieldset class="options-form">
                    <legend>
                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_MEMBERSHIP_INFO'); ?>
                    </legend>
                    <div class="dlk-field-container" data-hasdlk="<?php echo $package->dlkData['dlk'] ? 1 : 0; ?>" data-accesscode="<?php echo $package->dlkData['access']; ?>" data-tmplstyleid="<?php echo $template->id; ?>">
                        <label for="dlk-field" class="form-label"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_DOWNLOAD_KEY'); ?></label>
                        <div class="input-group">
                            <input type="password" id="dlk-field" name="dlk-field" value="<?php echo $package->dlkData['dlk']; ?>" class="form-control" readonly required="required" autocomplete="off" spellcheck="false" data-dlkfield />
                            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#dlkFormModal">
                                <span class="if-has-no-dlk"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ADD'); ?></span>
                                <span class="if-has-dlk"><?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_EDIT'); ?></span>
                            </button>
                            <button type="button" class="btn btn-primary if-has-dlk" data-dlk="revalidate">
                                <span class="dlk-btn-spinner spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_REVALIDATE'); ?>
                            </button>
                            <button type="button" class="btn btn-danger if-has-dlk" data-dlk="remove">
                                <span class="dlk-btn-spinner spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_REMOVE'); ?>
                            </button>
                        </div>
                        <div class="if-has-dlk">
                            <div class="if-has-access-0 form-control-hint text-danger">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_MEMBERSHIP_EXPIRED_MSG'); ?>
                            </div>
                            <div class="if-has-access-1 form-control-hint text-success">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_MEMBERSHIP_ACTIVE_MSG'); ?>
                            </div>
                            <div class="if-has-access-2 form-control-hint text-warning">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_MEMBERSHIP_UNSURE_MSG'); ?>
                            </div>
                            <?php if (!empty($package->dlkData['last_checked']) && \DateTime::createFromFormat('Y-m-d H:i:s', $package->dlkData['last_checked'])) : ?>
                                <div class="form-control-hint text-muted">
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_LAST_VALIDATED'); ?>:&nbsp;
                                    <span data-lastchecked><?php echo HTMLHelper::_('date', $package->dlkData['last_checked'], 'F d, Y H:i'); ?></span>
                                </div>
                                <input type="hidden" name="revalidate_dlk" value="<?php echo $package->dlkData['revalidate']; ?>" />
                            <?php elseif (!empty($package->dlkData['last_checked'])) : ?>
                                <div class="form-control-hint text-muted">
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_LAST_VALIDATED'); ?>:&nbsp;
                                    <span data-lastchecked><?php echo $package->dlkData['last_checked']; ?></span>
                                </div>
                                <input type="hidden" name="revalidate_dlk" value="1" />
                            <?php else : ?>
                                <div class="form-control-hint text-muted">
                                    <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_LAST_VALIDATED'); ?>:&nbsp;
                                    <span data-lastchecked></span>
                                </div>
                                <input type="hidden" name="revalidate_dlk" value="0" />
                            <?php endif; ?>
                        </div>
                        <?php echo HTMLHelper::_('bootstrap.renderModal', 'dlkFormModal', ['title'  => Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_ADD_DOWNLOAD_KEY')], $dlkForm); ?>
                    </div>
                </fieldset>
            </div>
            <div class="col-lg-6">
                <fieldset class="options-form">
                    <legend>
                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FILE_VERIFICATION'); ?>
                    </legend>
                    <div class="file-verification-container" data-action="verifyfiles" data-tmplstyleid="<?php echo $template->id; ?>" data-state="loading" data-found="0" data-haschange="0" data-hasnew="0" data-hasdeleted="0">
                        <div class="if-state-loaded">
                            <p class="if-found mb-4">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FILE_VERIFICATION_HAS_CHANGES'); ?>
                            </p>
                            <p class="if-not-found text-success mb-1">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FILE_VERIFICATION_NO_CHANGES'); ?>
                            </p>
                            <div class="if-found">
                                <div class="if-haschange">
                                    <div class="d-flex flex-row align-items-center gap-2 mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_CHANGED_FILES'); ?>
                                        <span class="badge bg-warning px-2" data-element="changed-count">0</span>
                                    </div>
                                    <div class="text-muted text-small mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_CHANGED_FILES_DESC'); ?>
                                    </div>
                                    <pre class="preformatted-files" data-element="changed-files"></pre>
                                </div>
                                <div class="if-hasnew">
                                    <div class="d-flex flex-row align-items-center gap-2 mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_NEW_FILES'); ?>
                                        <span class="badge bg-success px-2" data-element="new-count">0</span>
                                    </div>
                                    <div class="text-muted text-small mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_NEW_FILES_DESC'); ?>
                                    </div>
                                    <pre class="preformatted-files" data-element="new-files"></pre>
                                </div>
                                <div class="if-hasdeleted">
                                    <div class="d-flex flex-row align-items-center gap-2 mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_DELETED_FILES'); ?>
                                        <span class="badge bg-danger px-2" data-element="deleted-count">0</span>
                                    </div>
                                    <div class="text-muted text-small mb-2">
                                        <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_DELETED_FILES_DESC'); ?>
                                    </div>
                                    <pre class="preformatted-files" data-element="deleted-files"></pre>
                                </div>
                            </div>
                        </div>
                        <div class="if-state-error">
                            <p class="text-danger" data-element="error-message">
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FILE_VERIFICATION_FAILED'); ?>
                            </p>
                        </div>
                        <div class="if-state-loading">
                            <div class="d-flex flex-row align-items-center gap-3">
                                <div class="spinner-border text-secondary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_FILE_VERIFICATION_RUNNING'); ?>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
    <?php else : ?>
        <?php if ($template->parent) : ?>
            <p class="bg-info text-light p-3">
                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_CUSTOM_CHILD_MISSING_PACKAGE_INFO'); ?>
            </p>
        <?php else : ?>
            <p class="bg-danger text-light p-3">
                <?php echo Text::_('PLG_SYSTEM_VPPRIME_PRIMEADMIN_FIELD_MISSING_PACKAGE_INFO'); ?>
            </p>
        <?php endif; ?>
    <?php endif; ?>
</div>
