<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 * @phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

if (!function_exists('vp_dump')) {
    /**
    * Method to print any data with debug information.
    * Used in debuggin purpose. Similar to vardump but more advanced.
    *
    * @param mixed $data Any type of data but form xml object
    *
    * @return void
    */
    function vp_dump($data, $debug = true)
    {
        ob_start();
        print_r($data);

        $str = ob_get_contents();

        ob_end_clean();

        echo '<pre class="vp_dump" dir="ltr" style="font-size: 14px;">';
        echo '<small>' . gettype($data) . '</small> ';
        echo '<font color="#cc0000">' . $str . '</font>';
        echo '<i>{Length: ' . strlen($str) . '}</i>';

        if ($debug) {
            $backTraces = function_exists('debug_backtrace') ? debug_backtrace() : array();

            echo '<ul style="margin:15px 0; padding:15px; list-style-position:inside; background: #FAFAFA; border: 1px solid #DDD; line-height: 1.4;">';

            foreach ($backTraces as $backTrace) {
                echo '<li>';
                echo '<b>File:</b> ' . @$backTrace['file'] . '  <b>Line:</b> ' . @$backTrace['line'];
                echo isset($backTrace['class']) ? '  <b>Class:</b> ' . $backTrace['class'] : '';
                echo isset($backTrace['function']) ? '  <b>Function:</b> ' . $backTrace['function'] : '';
                echo '</li>';
            }

            echo '<li><b>Current Memory Usage:</b> ' . VPCalculateSize(memory_get_usage()) . '</li>';
            echo '<li><b>Peak Memory Usage:</b> ' . VPCalculateSize(memory_get_peak_usage()) . '</li>';

            echo '</ul>';
        }

        echo '<br/>';
        echo '</pre>';
    }
}

if (!function_exists('VPCalculateSize')) {
    function VPCalculateSize($size)
    {
        if ($size < 1024) {
            return $size . ' bytes';
        } elseif ($size < 1048576) {
            return round($size / 1024, 2) . ' KB';
        } else {
            return round($size / 1048576, 2) . ' MB';
        }
    }
}
