<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\HTML\HTMLHelper;

$attributes = [];

$attributes['class'] = 'mod-vmcategory-dropdown-menu--item-anchor';

$linktype = '<span class="mod-vmcategory-dropdown-menu--item-title">' . $item->title . '</span>';

if ($item->id == $active_id) {
    $attributes['aria-current'] = 'location';

    if ($item->current) {
        $attributes['aria-current'] = 'page';
    }
}

$linktype = '<span class="mod-vmcategory-dropdown-menu--item-inner">' . $linktype . '</span>';

if ($item->deeper) {
    $linktype .= '<span class="mod-vmcategory-dropdown-menu--item-sub-opener" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>';
}

echo HTMLHelper::_('link', OutputFilter::ampReplace(htmlspecialchars($item->flink, ENT_COMPAT, 'UTF-8', false)), $linktype, $attributes);
