<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle('mod_vpprime_virtuemart_category_dropdown', 'mod_vpprime_virtuemart_category/dropdown.css', ['version' => 'v1.2']);

$id = '';

if ($tagId = $params->get('tag_id', '')) {
    $id = ' id="' . $tagId . '"';
}
?>
<div<?php echo $id; ?> class="mod-vmcategory-dropdown" role="navigation" aria-label="<?php echo Text::_('MOD_VPPRIME_VIRTUEMART_CATEGORY_DROPDOWN_ARIA_LABEL'); ?>">
    <span class="mod-vmcategory-dropdown-opener">
        <span class="mod-vmcategory-dropdown-opener-icon">
            <i class="fas fa-bars" aria-hidden="true"></i>
        </span>
        <span class="mod-vmcategory-dropdown-opener-label">
            <?php echo $module->showtitle ? $module->title : Text::_('MOD_VPPRIME_VIRTUEMART_CATEGORY_DROPDOWN_ARIA_LABEL'); ?>
        </span>
    </span>
    <div class="mod-vmcategory-dropdown-drop">
        <ul class="mod-vmcategory-dropdown-menu<?php echo $class_sfx ? ' ' . $class_sfx : ''; ?>">
        <?php foreach ($list as $i => &$item) {
            $itemParams = $item->getParams();
            $class      = 'mod-vmcategory-dropdown-menu--item item-' . $item->id;

            if ($item->id == $default_id) {
                $class .= ' mod-vmcategory-dropdown-menu--default';
            }

            if ($item->id == $active_id || ($item->type === 'alias' && $itemParams->get('aliasoptions') == $active_id)) {
                $class .= ' mod-vmcategory-dropdown-menu--current';
            }

            if (in_array($item->id, $path)) {
                $class .= ' mod-vmcategory-dropdown-menu--active';
            } elseif ($item->type === 'alias') {
                $aliasToId = $itemParams->get('aliasoptions');

                if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
                    $class .= ' mod-vmcategory-dropdown-menu--active';
                } elseif (in_array($aliasToId, $path)) {
                    $class .= ' mod-vmcategory-dropdown-menu--alias-parent-active';
                }
            }

            if ($item->type === 'separator') {
                $class .= ' mod-vmcategory-dropdown-menu--divider';
            }

            if ($item->deeper) {
                $class .= ' mod-vmcategory-dropdown-menu--deeper';
            }

            if ($item->parent) {
                $class .= ' mod-vmcategory-dropdown-menu--parent';
            }

            $class .= ' mod-vmcategory-dropdown-menu--level-' . $item->menu_level;

            echo '<li class="' . trim($class) . '">';

            require ModuleHelper::getLayoutPath('mod_vpprime_virtuemart_category', 'dropdown_' . $item->type);

            // The next item is deeper.
            if ($item->deeper) {
                echo '<ul class="mod-vmcategory-dropdown-menu--sub">';
            } elseif ($item->shallower) {
                // The next item is shallower.
                echo '</li>';
                echo str_repeat('</ul></li>', $item->level_diff);
            } else {
                // The next item is on the same level.
                echo '</li>';
            }
        }
        ?></ul>
    </div>
</div>
