<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Virtueplanet\Module\VirtueMartCategory\Site\Helper\MenuHelper;

$list                       = MenuHelper::getList($params);
$base                       = MenuHelper::getBase($params);
$active                     = MenuHelper::getActive($params);
$default                    = MenuHelper::getDefault();
$activeVirtuemartCategoryId = MenuHelper::getActiveVirtuemartCategoryId();
$active_id                  = $activeVirtuemartCategoryId ? $activeVirtuemartCategoryId : $active->id;
$default_id                 = $default->id;
$path                       = $base->tree;
$showAll                    = $params->get('showAllChildren', 1);
$class_sfx                  = htmlspecialchars($params->get('class_sfx', ''), ENT_COMPAT, 'UTF-8');
$module_class_sfx           = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');

if (!$list) {
    return;
}

require ModuleHelper::getLayoutPath('mod_vpprime_virtuemart_category', $params->get('layout', 'default'));
